<?php

namespace Drupal\announcements\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface for defining Announcement type entities.
 */
interface AnnouncementTypeInterface extends ConfigEntityInterface {

  /**
   * Checks the dismissible property value.
   *
   * @return boolean
   *   The dismissible value.
   */
  public function isDismissible(): ?bool;

  /**
   * Sets the dismissible property value.
   *
   * @param boolean $dismissible
   *   The new value.
   */
  public function setDismissible(bool $dismissible);

}
