<?php

namespace Drupal\announcements;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Announcement entities.
 *
 * @ingroup announcements
 */
class AnnouncementListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('Announcement ID');
    $header['name'] = $this->t('Name');
    $header['region'] = $this->t('Region');
    $header['style'] = $this->t('Style');
    $header['visibility'] = $this->t('Visibility');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var \Drupal\announcements\Entity\Announcement $entity */
    $row['id'] = $entity->id();
    $row['name'] = $entity->toLink(NULL, 'edit-form');
    $row['region'] = 'TODO';
    $row['style'] = $entity->get('style')->first()->entity->label();
    $row['visibility'] = 'TODO';
    return $row + parent::buildRow($entity);
  }

}
