<?php

namespace Drupal\announcements\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Class AnnouncementTypeForm.
 */
class AnnouncementTypeForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $form = parent::form($form, $form_state);

    $announcements_type = $this->entity;
    $form['label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label'),
      '#maxlength' => 255,
      '#default_value' => $announcements_type->label(),
      '#description' => $this->t("Label for the Announcement type."),
      '#required' => TRUE,
    ];

    $form['id'] = [
      '#type' => 'machine_name',
      '#default_value' => $announcements_type->id(),
      '#machine_name' => [
        'exists' => '\Drupal\announcements\Entity\AnnouncementType::load',
      ],
      '#disabled' => !$announcements_type->isNew(),
    ];

    $form['dismissible'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Dismissible'),
      '#default_value' => $announcements_type->isDismissible(),
      '#description' => $this->t("Should announcements of this type be dismissible."),
    ];

    /* You will need additional form elements for your custom properties. */

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $announcements_type = $this->entity;
    $status = $announcements_type->save();

    switch ($status) {
      case SAVED_NEW:
        $this->messenger()->addMessage($this->t('Created the %label Announcement type.', [
          '%label' => $announcements_type->label(),
        ]));
        break;

      default:
        $this->messenger()->addMessage($this->t('Saved the %label Announcement type.', [
          '%label' => $announcements_type->label(),
        ]));
    }
    $form_state->setRedirectUrl($announcements_type->toUrl('collection'));
  }

}
