<?php

namespace Drupal\announcements\Plugin\Block;

use Drupal\Core\Block\BlockBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a 'AnnouncementsRegionBlock' block.
 *
 * @Block(
 *  id = "announcements_region_block",
 *  admin_label = @Translation("Announcements Region"),
 *  category = @Translation("Announcements"),
 *  deriver = "Drupal\announcements\Plugin\Derivative\AnnouncementRegions"
 * )
 */
class AnnouncementsRegionBlock extends BlockBase implements ContainerFactoryPluginInterface {

  protected $announcementStorage;
  protected $announcementViewBuilder;

  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    $instance = new static($configuration, $plugin_id, $plugin_definition);

    $entity_type_manager = $container->get('entity_type.manager');

    $instance->announcementStorage = $entity_type_manager->getStorage('announcements_announcement');
    $instance->announcementViewBuilder = $entity_type_manager->getViewBuilder('announcements_announcement');

    return $instance;
  }

  public function getRegionId() {
    $definition = $this->getPluginDefinition();

    return $definition['announcements_region'];
  }

  public function getAnnoucementDisplayMode() {
    $definition = $this->getPluginDefinition();

    return $definition['announcement_display_mode'] ?? 'default';
  }

  /**
   * {@inheritdoc}
   */
  public function build() {
    $announcements = $this->announcementStorage->loadActiveForRegion($this->getRegionId());

    $build = [];
    $build['#theme'] = 'announcements_region_block';

    $display_mode = $this->getAnnoucementDisplayMode();

    foreach ($announcements as $announcement) {
      $build['announcements-' . $announcement->id()] = $this->announcementViewBuilder->view($announcement, $display_mode);
      $build['announcements-' . $announcement->id()]['#region'] = $this->getRegionId();
    }

    return $build;
  }

}
