<?php

/**
 * Implements hook_views_pre_render().
 *
 * Hook into view rendering process to replace anonymous string or username with
 * the content of field_anonymous_author field.
 */
function anonymous_posting_views_pre_render(&$view) {

  // Find out if this view is based on a node with some relationship with users.
  if ($view->base_table === 'node') {    
    foreach ($view->relationship as $relationship_handler) {
      if (isset($relationship_handler->definition['base'])
        && $relationship_handler->definition['base'] === 'users') {
        
        // Find out if the User name field is used for that view and get its 
        // alias if found.
        $user_name_field_alias = NULL;
        foreach ($view->field as $field_name => $field_hander) {
          if (is_a($field_hander, 'views_handler_field_user_name')) {
            $user_name_field_alias = $field_hander->field_alias;
            break;
          }
        }

        // Insert contact information name into views user name (Author) field if any.
        if ($user_name_field_alias) {
          foreach($view->result as $row) {
            $field_values = _anonymous_posting_get_field_values($row->nid);
            if (isset($field_values['name'])) {
              $row->{$user_name_field_alias} = check_plain($field_values['name']);
              if (isset($row->node_comment_statistics_last_comment_name)
                && !$row->node_comment_statistics_comment_count) {
                $row->node_comment_statistics_last_comment_name = $row->{$user_name_field_alias};
              }

              // Remove the following property so that
              // views_handler_field_user_name handler wont insert link to
              // user id.
              unset($row->users_node_uid);
            }      
          }
        }
        break;
      }
    }
  }  
}
