<?php

/**
 * @file
 * Anonymous publishing mail handling.
 */

/**
 * Send verification email.
 *
 * @param object $node
 *   The node object.
 * @param text $akey
 *   Activation key
 */
function _anonymous_publishing_send_email($node, $akey) {
  global $base_url;
  $options = variable_get('anonymous_publishing_options', array());
  if (isset($node->title)) {
    // node
    $title = $node->title;
    $vfurl = url($base_url . '/node/' . $node->nid . '/verify', array('query' => array('akey' => $akey)));
    $modp = !$options['sactivate'];
  }
  else {
    // comment
    $title = $node->subject;
    if (empty($title)) {
      $title = '';
    }
    $vfurl = url($base_url . '/comment/' . $node->cid . '/verify', array('query' => array('akey' => $akey)));
    $modp = !user_access('skip comment approval');
  }
  $autodelhours = variable_get('anonymous_publishing_autodelhours', '48');

  //dpm($node);
  $from = variable_get('site_mail', ini_get('sendmail_from'));
  $variables = array(
    '!action' => $modp ? t('verify') : t('activate'),
    '!autodelhours' => $autodelhours,
    '!email' => $node->anonymous_publishing['email'],
    '!site' => variable_get('site_name', 'Drupal'),
    '!title' => check_plain($title), // Comments may not have a title.
    '!verification_uri' => $vfurl,
    '!view_uri' => url($base_url . '/node/' . $node->nid . '/view', array('query' => array('akey' => $akey))),
  );

  $params = array();
  //dpm($modp, 'modp');
  $to = $node->anonymous_publishing['email'];
  $subject = _anonymous_publishing_email_text($modp ? 'subjectver' : 'subjectact', $variables);
  $b1 = _anonymous_publishing_email_text('action', $variables);
  $b2 = 999 > $autodelhours ?_anonymous_publishing_email_text('activate', $variables) : '';
  $b3 = $modp ? _anonymous_publishing_email_text('verify', $variables) : '';
  //$b4 = _anonymous_publishing_email_text('preview', $variables);
  //$body = $b1 . $b2  . $b3;
  $body = array($b1, $b2, $b3);

  $message = array(
    'id' => 'anonymous_publishing_verify',
    'to' => $to,
    'subject' => $subject,
    'body' => $body,
    'headers' => array(
      'From' => $from,
      'Sender' => $from,
      'Return-Path' => $from,
      'MIME-Version' => '1.0',
      //'Content-Type' => 'text/plain; charset=UTF-8; format=flowed; delsp=yes',
      'Content-Type' => 'text/plain; charset=UTF-8',
      'Content-Transfer-Encoding' => '8bit',
      'X-Mailer' => 'Drupal',
    ),
  );
  $system = drupal_mail_system('anonymous_publishing', 'verify');
  dpm($system, 'mailsystem'); // DEBUG
  $message = $system->format($message);

  $result = $system->mail($message);
  dpm($result, 'result');
  if ($result) {
    drupal_set_message(t('A link and further instructions have been sent to your e-mail address.'));
    watchdog('anonymous_publishing', t('Verification mail sent to @to from @from.', array('@to' => $to, '@from' => $from)));
  }
  else {
    watchdog('anonymous_publishing', 'Error mailing activation/verification link.');
    drupal_set_message(t('Unable to send mail. Please contact the site admin.'), 'error');
  }

  if ($options['modmail']) {
    $admin = user_load(1);
    $subject = _anonymous_publishing_email_text('nsubject', $variables);
    $body = _anonymous_publishing_email_text('nbody', $variables);
    $body = wordwrap($body);
    $body = str_replace("\n", "\r\n", $body);

    $message = array(
      'id' => 'anonymous_publishing_notify',
      'to' => variable_get('anonymous_publishing_moderator', $admin->mail),
      'subject' => $subject,
      'body' => $body,
      'headers' => array(
        'From' => $from,
        'Sender' => $from,
        'Return-Path' => $from,
        'MIME-Version' => '1.0',
        'Content-Type' => 'text/plain; charset=UTF-8; format=flowed; delsp=yes',
        'Content-Transfer-Encoding' => '8bit',
        'X-Mailer' => 'Drupal',
      ),
    );
    $system = drupal_mail_system('anonymous_publishing', 'notify');
    if (!$system->mail($message)) {
      watchdog('anonymous_publishing', 'Error notifying admin.');
    }
  }
}
