## CONTENTS OF THIS FILE

* Introduction
* Recommended modules
* Installation
* Configuration
  - Anonymous publishing CL
  - Anonymous publishing LR
  - Anonymous publishing PET
* Troubleshooting
  - No email
* Spam protection
* Known glitches
* Maintainers


# INTRODUCTION

The **Anonymous publishing** module increases your control over anonymous
publishing on a site.

* For a full description of the module, visit the [project page][1].

* To submit bug reports and feature suggestions, or to track changes
  visit the project's [issue tracker][2].

* For community documentation, visit the [documentation page][3].

**Anonymous publishing** may lower the threshold for authorship and entry
to a site.  It may also be a requirement for certain sites that deal
with sensitive issues that anonymous publishing is allowed.

In Drupal, the administrator may grant the anonymous user the right to
create new content (so you don't need this module to allow anonymous
users to create content). However, allowing anonymous publishing may
have the side-effect of making the site wide open to spammers.  This
module may be used to mitigate that.  Also, it implements a privacy
enhancing technology (PET) that allows authenticated users publish
anonymously.

The major features of **Anonymous publishing** are:

1. Users may publish content without first registering an account at
   the site, provided they supply a vaild email address and click on
   an activation link sent them in a verification email (some call
   this the “craigslist model”). To use this feature enable the
   **Anonymous publishing CL** submodule.

2. “Lazy” registration, where the user creates the content first and
   can then “claim” the content after registering on the site. If you
   enable this submodule, there will be a tab named “Claim anonymous
   posts” on the profile page of users with “unclaimed” content they
   created on the site before they registered. To use this feature
   enable the **Anonymous publishing LR** submodule.

3. Authenticated users may publish content that appear to be published
   by Anonymous (i.e. they need to be authenticated and logged in to
   publish, but the content they tag as anonymous will never be
   publicly associated with their user name or other identity). To use
   this feature enable the **Anonymous publishing PET** submodule.

More specifically, it may:

- let anonymous publishers self-activate;
- retain self-activated email addresses for future use;
- send email to administrators when anonymous content is created;
- provide simple moderation of content published anonymously;
- let the administrator block abusers based on email & IP address;
- track spambots and let the administrator block them,
- provide flood control;
- purge records that links the identifier to specific content;
- let the administrator customize the verification email;
- allow authenticated users to publish as the anonymous user;
- associate a persistent byline/alias with *all* content published anonymously;
- the persistent byline/alias can be default, generated or set by the publisher.


## RECOMMENDED MODULES

* [Advanced Help][4]:
  When this module is enabled, display of the project's `README.md`
  will be rendered when you visit
  `help/anonymous_publishing/README.md`.
* [Markdown filter][5]:
  When this module is enabled, display of the project's `README.md`
  will be rendered with the markdown filter.


# INSTALLATION

1. Install as you would normally install a contributed drupal
   module. See: [Installing modules][6] for further information.

2. Enable the **Anonymous publishing** module on the *Modules* list
   page.  The database tables will be created automagically for you at
   this point.

3. Check the *Status report* to see if it necessary to run the
   database update script.

4. Enable the submodules providing the features you want to use.

5. Proceed to configure each of the submodules, as described in the
   configuraton section below.


# CONFIGURATION

By itself, the parent module does nothing. You need to enable at least
one of the project's submodules to be able to use the feature's of
this project.

The forms to configure the **Anonymous publishing CL** and **Anonymous
publishing PET** submodules are found by navigating to:

    Admin » Configuration » People

**Anonymous publishing LR** does not have a configuration form.

Below is a description of how to configure all three submodules.

## Anonymous publishing CL

To access the **Anonymous publishing CL** administration form, you need to
be granted the right to administer anonymous publishing.

After installing and activating the module navigate to:

    Admin » Configuration » People » Anonymous publishing CL

There are seven tabs:

1. **Main settings**: All the main options for this module.
2. **Message templates**: Customize verificaton email sent out.
3. **Moderation**: Moderate anonymously published content.
4. **Verified**: Block (and unblock) verified email addresses.
5. **Unverified**: Ban unverified users' IP addresses.
6. **Spambots**: Ban reported spambots' IP addresses.
7. **Privacy**: Privacy enhancing settings.


### Main settings

You first need to select the content type (or types) that you will
allow anonymous users to post.  You may also enable anonymous
publishing for comments.

If you want to allow users that are not logged in to create content,
you must also give permission for the anonymous user to create
content.  This is by done navigating to:

    Admin » People » Permissions.

The rest of the settings on the settings page will only have an effect
on the type or types (including comments) selected here.

Here is a brief description of the options:

- Allow self-activation.
  If you check this option, content from anonymous publishers that has
  not been previously validated will be automatically published when
  the anonymous publisher verifies the email.  If you leave this
  un-checked, content from un-validated anonymous publishers will be
  flagged as verified when the user verify the email address, but it
  will not be published until approved by a administrator.  The
  setting has no effect if the email address is already validated.
  (See description of the “Moderation” panel below for details about
  how activation works.)

- Skip comment approval.
  This is greyed out, as this setting is managed by the Drupal core
  comment module.  Go to `Admin » People » Permissions` to set
  it.  The core “Skip comment approval” setting retains it standard
  meaning and its status is only included in this panel for
  information purposes (previous setting).  Note that if you allow
  self-activation, but don't also check “Skip comment approval”,
  self-activated comments will not be published when the user
  activates.  They will just be flagged as verified and not be
  published until they are approved by a moderator.  To avoid
  confusion, make sure this setting is in-sync with the setting Allow
  self-activation.

- Send email to the administrator when anonymous content is created.
  Checking this will automatically send an email to the administrator
  email address whenever anonymous content is created.  You may
  use this to make sure the administrator becomes aware of possible
  problems (such as spam), or to speed up the moderation process
  (if you do not allow self-activation).

- Use IP-address for blocking.
  By default, the “blocking” box only applies to the email used for
  authentication. The module records the IP-address used to
  authenticate, but this normally only used for flood control
  purposes.  When this option is set, the module will also block the
  corresponding IP-address.  Note that setting this option may result
  in false positives (as one IP-address may be shared between several
  users over time), so use this option with caution.

- Allow registered emails to be used for anonymous posts.
  By default, if a user has already registered and created a regular
  account on the website, that email can no longer be used for
  anonymous posts.  If you want to allow regular users to be able to
  publish as the anonymous user role, enable the **Anonymous
  publishing PET** sub-module.  However, you may override this
  behaviour by setting this option.  This security implications, as
  somebody familiar with your users will be able to guess the email
  address of a registered user and use this to post harmful content
  which the regular user may be blamed for.  It is recommended to turn
  of stickyness for self-activation if you enable this option.

The setting for verification persistency determines whether users need
to re-verify after they've verified (or have been verified) once.  The
settings are:

1. Make verification persistent.
   If this option is set, a verified email address will be trusted,
   relieving the user from the task of re-verifiying on return visists
   to the site (see “Verified” below).

2. Verification persists as long as the same IP is used.
   If this option is set, a verified email address will be trusted if
   the IP-address used to post matches the previous IP-address used
   used along with the same email address.

3. Require verification for each posting.
   If you set this option, users will have to re-verify their email
   address again every time they post.  This is the most secure
   setting, but also bit more of a burden on the user.

The setting for the attribution or byline (“To whom should anonymous
postings be attributed”) can only be used if the retention period (set
on the Privacy tab) is set to “Indefinitely”.  When accessible, it
lets you choose between the following three options:

1. Use the default alias for anonymous users.
   This means that *all* anonymous postings will share the *same*
   byline.

2. Use an generated persistent alias (format “user*N*”).
   This means that anonymous postings will associated with the *same*
   email address will share the *same* byline. The byline will be
   automatically generated and cannot be personalized.

3. Allow the anonymous publisher to set the byline.
   This works like the one of the previous previous two options. If no
   alias is given, the default will be used. If the user selects an
   alias, it may be personalized.

4. Require anonymous publisher to set the byline.
   This requires the user to select a personalized persistent byline
   unless it has been set previously.

If you select option 1 (use the default alias) after having one of the
options for a persistent alias active for some time, the aliases will
no longer appear.  They will, however reappear if you select options
2-4.

If you select option 2 (generated alias), it will only affect *new*
anonymous publishers. email addresses already known by the system
will retain its existing alias/byline association.

If you select options 3 or 4 (user sets byline), the field to define
an byline will appear on the content creation form for anonymous
publishers. If the email address given by the user already has an
byline associated with it, the new byline will take presedence over
the old for all anonymous postings *unless* the user leaves the field
blank. If the email address given is unknown and the user leaves the
field blank, an alias will be generated for the user if option 3 is
selected.  If option 4 is selected, the bylibe field cannot be left
blank.

**NOTE**: The privacy settings of this sub-module let the
administrator purge the information that links email addresses to
anonymously published content from the datebase after some pre-set
retenion period or immediately.  This will delete all information
linking specific content to activation email addresses. After
purging, the it will no longer be possible to use an alias as a
byline.  Purging is not reversible.

- Guidelines for the byline.
  If you select option 3 (user sets byline) you may provide a short
  text of guidance in this field. This field is not used by options 1
  and 2.

The last four settings are:

- Administrator's email address.
  If you opt to send email to the administrator when anonymous
  content is created, you need to provide a vaild email address for
  the administrator.

- Verification email address field weight.
  To control where on create content form the verification email
  address field is placed, you may specify a weight for this field.

- Number of hours to retain anonymous posts before auto-deletions
  removes it.
  Spammers often creates contents on sites that allow them to do so,
  but almost never act on the verification email.  This settings can
  be used to automatically delete anonymous posts if the email has not
  yet ben verified after the number of hours you set here.  It will
  also delete the entry for the spammer under the “unverified” tab.
  Use -1 for no limit.

- Number of anonymous posts allowed from a single user email/ip
  allowed within an hour.
  For flood control, you may set the number of anonymous posts allowed
  from a single email-address or ip-address within an hour.  Use -1
  for no limit.

Remember to press “Save configuration” when done.


### Message templates

In this panel, there are four fields that let the administrator
customize the email message sent to non-authenticated users when they
create content. The first field is the subject, the rest of the fields
may go in the body. Other settings determine what fields are used.

There is also two templates (subject and body) for the email sent to
the administrator.


### Moderation

This panel shows all the comtent published anonymously that have been
verified by email.  It lets the administrator publish or unpublish.

The moderation workflow of anonymous publishing is tied to the option
“Allow self-activation”.  If you check this option, the user is
allowed to selv-activate content by verifing his or her email address.
If you leave this option unchecked, content created by unverified
anonymous publishers will not become activated until it is approved by
a moderator.

Also note that the setting for “Skip comment approval” is still taken
into account.  If you do not check <em>both</em> the options “Allow
selv-activation” and “Skip comment approval”, a comment will not be
published until it is published by a moderator.

### Verified

This panels list all the verified emails and their current status.

Also listed is the byline associated with each email address.  The
byline will only be shown publicly if you do *not* opt for using the
default alias for anonymous users under main settings.

Also listed is the IP-address associated with each email.  The
IP-address listed will be used for blocking if you mark the email as
blocked and you've checked “Use IP-address for blocking” under main
settings.

Email addresses that are blocked from anonymous publishing is shown
with a check-mark in the column “blocked”.

To block, set a check-mark in the row of the email address.  To
unblock, remove this check-mark. To make changes take effect, press
“Execute”.

Note that a checkmark in the “blocked” column will only prevent the
user from posting anonymously.  No other part of the site's
functionality will be affected. Unlike the *ban IP* blocking action
you may take in the “Unverified” and “Spambots” panels, this blocking
is handled by this module, not by Drupal.

This status of blocked is only meant to be used to block abusive human
users from publishing anonymously, not to ban spambots.

The final column under the Verified tab has the heading “Remove”.  If
you check the checkboxes in this column and press “Execute”, all
checked user entries will be removed from the list of verified
anonymous posters. This will require the affected users to validate
again the next time they post anonymously.  Note that this operation
will also remove the persistent byline associated with the users (if
set), but it will not removce the anonymous postings they've already
created.  This operation can not be undone.

### Unverified

This panels list all the emails IP-addresses that has been associated
with anonymous publishing that has not yet verified by email and how
long it has remained unverified.

This panel provides a shortcut to admins that want to delete
unpublished spams posts and at the same time ban the IP-address used
to post it.  Placing a mark in the “delete+ban IP” column to the right
of an posting listed here will delete the posting and add the
IP-address used to post it to the Drupal's `{blocked_ips}` table.
Banned IP-addresses will not have access to any part of site at all.

To unban an IP address, navigate to:

    Admin » Configuration » People » IP address blocking

and press “delete” for the IP-address you want to unblock.


### Spambots

The spambots panel shows the IP-address of the “Top 10” spambots
targeting the site, along with some simple statistics.  You can ban an
IP address by placing a check-mark in the “ban IP” column.  When you
press “Execute”, the IP-address will is moved to the list of
IP-addresses blocked by Drupal.

To unban an IP address, follow the same procedure as suggested above.


### Privacy

While no email address or username is made available to outsiders,
the email address and IP-address associated with content is by default
retained indefinitely, and can be extracted from the database.  If
your site is used to publish sensitive material, you may want to limit
the period the record that links emails and IP-addresses to specific
content is retained.

For a very sensitive site, you may want to set this to “Delete ASAP”
to delete at next cron run.  But you may also opt to retain for a
limited time (from an hour up to 1 month) to give you some time to
pick up the email addresses or IP-addresses of spammers and block
them.  The purging of email adresses and IP-addresses is done by
cron, so you need to run cron at least as often as half the maximum
period set to be sure identifiers are purged within the time limit.

The button “Purge now” bypasses cron and purges the identifiers
instantly.


### Other administration

If you want users that are not logged in to be able to create content,
you also need to navigate to

    Admin » People » Permissions

and check the following for the anonymous user:

- View published content

Then for each of the content type(s) you want to allow anonymous
publishing for, check the following for the Anonymous user:

- Create new content

To allow the anonymous user to post comments, grant the following
permissions:

- View comments
- Post comments
- Skip comment approval

To get rid of the “(Not verified)” string that appears next to the
user name of any content posted by the anonymous user, navigate to

    Admin » Appearance » Settings » Global settings

and uncheck the following:

- User verification status in comments


## Anonymous publishing LR

If you enable the **Anonymous publishing LR** submodule, “lazy”
registration (where people can post first, and register later) is
enabled.

When this submodule is enabled, when a user that already has published
content using **Anonymous publishing CL** registers on the site with
the same email address as he or she used when creating anonymous
postings, he or her will see a tab named “Claim anonymous posts” on
the “my account” profile page. This tab will allow the user to “claim”
the posts they created as an anonymous publisher for his/her profile
(i.e. if “claimed”, these posts will be owned by their logged in
profile).

Note that since this feature uses the email addresses to link the old
content to the new user, it is incompatible with the privacy functions
to purge email addresses available in the panel under the “Privacy”
tab.

There is no administrative interface to this submodule.  To make the
tab appear on the user's profile page. enable the submodule.  To make
the tab disappear, disable this submodule.



## Anonymous publishing PET

To access the **Anonymous publishing PET** administration form, you
need to be granted the right to administer anonymous publishing.

After installing and activating the module navigate to:

    Admin » Configuration » People » Anonymous publishing PET

There are three tabs:

1. **Main settings**: All the main options for this module.
2. **Real names**: List real user names of content published as anomymous.
3. **Privacy**: Privacy enhancing settings.


### Main settings

Under this tab, you check the content types where you want
authenticated users to be able to publish as the anonymous user role.
You may also enable this featire for comments.

The option “Allow authenticated users to publish as Anonymous” must
also be checked to have this feature available on the site.


### Real names

This panels lists the real user names and subject lines of content
that is published as anonymous.  It allows the administrator to
identify authenticated users that abuse the ability to post as
anonymous.

The rentention period of the user names listed here is controlled by
the settings under the privacy tab.


### Privacy

While no email address or real user names are made avialable to
outsiders, the email address and real user name associated with
content is by default retained indefinitely, and can be extracted from
the database.  If your site is used to publish sensitive material, you
may want to limit the period the record these records are retained.

For a very sensitive site, you may want to set this to “Delete ASAP”,
but you may also opt to retain for a limited time (from an hour up to
1 month) to give you some time to spot users abusing the privilege to
publish as the anonymous user.  The purging is done by cron, so you
need to run cron at least as often as half the maximum period set to
be sure identifiers are purged within the time limit.

The button “Purge now” bypasses cron and purges the identifiers
instantly.


# TROULESHOOTING

## No email

The **Anonymous publishing** module uses Drupal's DefaultMailSystem to
send out verification/activation emails (refer to the API
documentation at api.drupal.org for the function
[`drupal_mail_system`][7] for details.  It uses the method `mail` to
send the mail, and prints out the message:

> A link and further instructions have been sent to your email
address.

after after the mail was successfully accepted for by the mail for
delivery.

If the mail system rejects the message, it prints out:

> Error mailing activation/verification link.

If you get the error message, then there is probably something wrong
with the configuration of mail on your Drupal site.

Here are some things to check if you do not receive an email after
posting as anonymous, despite the fact that you're told that a link
and further instructions have been sent to your email address:

- The first thing you should check is that Drupal can send email at
  all. You can try using the Contact module (part of core) or you can
  request a password reset by logging out and clicking the “Request
  new password” link in the login block.

- Next check that verification/activation emails are not stopped by
  some spam-filter at the receiver end.  The sender of the emails
  sent by **Anonymous publishing** is the site's email address. You
  can inspect this at: `Admin » Configuration » System » Site
  information`.  Search your-spam folder for recent emails sent from
  this address.  Also note that there are some mail services
  (e.g. *mail.yahoo.com*) that have spam filters that consider the
  verification/activation emails from this module as spam and
  silently delete them. For testing, use a mail service where you
  control what is filtered.

- When testing this, make sure that the email address given by the
  anonymous poster is valid, and goes to a mailbox you've access to.

- Make sure that the site's email address is valid. Look for bounced
  verification/activation emails in the mailbox belonging to the
  site's email address.


# SPAM PROTECTION

If you allow anonymous publishing your site will probably be targeted
by spammers, both of the human kind, and 'bots.  There is already some
built-in 'bot protection, and very few spammers activate.  These
built-in features may be suffiscient to keep spam at bay.  If you need
more protection against spam, projects such as [**CAPTCHA**][8],
[**Riddle**][9], [**Spambot**][10] (and many others) may be good
companions.


# KNOWN GLITCHES

- The core **Comment** module allows anonymous publishers to pick
  their own non-persistent byline when they post a comment.  This
  conflicts with the persistent byline feature provided by this
  module, so this feature in Drupal is disabled when this module is
  enabled.

- When you associate a persistent byline with an email address, the
  byline will not appear when there is no content *directly*
  associated with the display (e.g. on the forum landing page).
  Instead the system default name for the anonymous user will appear.

# MAINTAINERS

**Anonymous publishing** was first created by [dropcube][11] (Ronny
López).
The current maintainer is [gisle][12] (Gisle Hannemyr).

Any help with development (patches, reviews, comments) are welcome.

Development has been sponsored by [Hannemyr Nye Medier AS][13].

[1]: https://drupal.org/project/anonymous_publishing
[2]: https://drupal.org/project/issues/anonymous_publishing
[3]: https://drupal.org/node/2024005
[4]: https://www.drupal.org/project/advanced_help
[5]: https://www.drupal.org/project/markdown
[6]: https://drupal.org/documentation/install/modules-themes/modules-7
[7]: https://api.drupal.org/api/drupal/includes!mail.inc/function/drupal_mail_system/7.x
[8]: https://drupal.org/project/captcha
[9]: https://drupal.org/project/riddle
[10]: https://drupal.org/project/spambot
[11]: https://www.drupal.org/user/37031
[12]: https://www.drupal.org/u/gisle
[13]: http://hannemyr.com/hnm/
