<?php
/**
 * @file
 * Contains \Drupal\anonymous_redirect\Tests\AnonymousRedirectConfigTest.
 */

namespace Drupal\anonymous_redirect\Tests;


use Drupal\simpletest\WebTestBase;
use Drupal\user\Entity\User;

/**
 * Tests for the Anonymous Redirect config form
 *
 * @group anonymous_redirect
 */
class AnonymousRedirectConfigTest extends WebTestBase{

  static public $modules = ['anonymous_redirect','node'];

  /**
   * @var $user User
   */
  private $user;




  protected function setUp() {
    parent::setUp(); // TODO: Change the autogenerated stub

    $this->user = $this->drupalCreateUser(['access content', 'administer site configuration']);

  }


  public function testConfigFormWorks(){

    // make the user an administrator
    $this->user->addRole('administrator');
    $this->user->removeRole('anonymous');

    // test that config form exists at specified route.
    $this->drupalLogin($this->user);
    $this->drupalGet('/admin/config/system/anonymous-redirect');
    $this->assertResponse(200);

    $config = $this->config('anonymous_redirect.settings');




    // test is the enable_anonymous_redirect field exists and holds an appropriate value
    $this->assertFieldByName('enable_anonymous_redirect', $config->get('enable_redirect'),'The Enable Redirect field was found with the correct value');

    // test is the redirect_base_url field exists and holds an appropriate value
    $this->assertFieldByName('redirect_base_url', $config->get('redirect_url'), 'The redirect_base_url field exists and holds an appropriate value');




    // test to see if the form saves correctly when supplied with appropriate vales
    $this->drupalPostForm('/admin/config/system/anonymous-redirect',[
      'enable_anonymous_redirect' => true,
      'redirect_base_url' => '<front>'
    ], t('Save configuration'));
    $this->assertText('The configuration options have been saved.', 'The form was saved correctly.');




    $this->drupalGet('/admin/config/system/anonymous-redirect');
    $this->assertResponse(200);

    // test to see if the values was set correctly
    $this->assertFieldByName('enable_anonymous_redirect', true,'Value for the  enable_redirect field was set successfully');
    $this->assertFieldByName('redirect_base_url', '<front>', 'Value for the redirect_base_url field was set successfully');
  }
}