<?php

namespace Drupal\anonymous_redirect\Tests;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests for the Anonymous Redirect config form.
 *
 * @group anonymous_redirect
 */
class AnonymousRedirectConfigTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  static public $modules = ['anonymous_redirect', 'node'];

  /**
   * {@inheritdoc}
   */
  protected function setUp() {
    // @todo Change the autogenerated stub.
    parent::setUp();

    $this->user = $this->drupalCreateUser([
      'access content',
      'administer site configuration',
    ]);
  }

  /**
   * Test if config form works as expected.
   */
  public function testConfigFormWorks() {
    // Make the user an administrator.
    $this->user->addRole('administrator');
    $this->user->removeRole('anonymous');

    // Test that config form exists at specified route.
    $this->drupalLogin($this->user);
    $this->drupalGet('/admin/config/system/anonymous-redirect');
    $this->assertResponse(200);

    $config = $this->config('anonymous_redirect.settings');

    // Check that enable_anonymous_redirect field exists with an appropriate
    // value.
    $this->assertFieldByName('enable_anonymous_redirect', $config->get('enable_redirect'), 'The Enable Redirect field was found with the correct value');

    // Check that redirect_base_url field exist with an appropriate value.
    $this->assertFieldByName('redirect_base_url', $config->get('redirect_url'), 'The redirect_base_url field exists and holds an appropriate value');

    // Check that redirect_url_overrides field exists with an appropriate value.
    $this->assertFieldByName('redirect_url_overrides', $config->get('redirect_url_overrides'), 'The redirect_url_overrides field exists and holds an appropriate value');

    // Check that the form saves correctly with appropriate values.
    $this->drupalPostForm('/admin/config/system/anonymous-redirect', [
      'enable_anonymous_redirect' => TRUE,
      'redirect_base_url' => '<front>',
      'redirect_url_overrides' => '/test',
    ], $this->t('Save configuration'));
    $this->assertText('The configuration options have been saved.', 'The form was saved correctly.');

    $this->drupalGet('/admin/config/system/anonymous-redirect');
    $this->assertResponse(200);

    // Check to see if the values were set correctly.
    $this->assertFieldByName('enable_anonymous_redirect', TRUE, 'Value for the  enable_redirect field was set successfully');
    $this->assertFieldByName('redirect_base_url', '<front>', 'Value for the redirect_base_url field was set successfully');
    $this->assertFieldByName('redirect_url_overrides', '/test', 'Value for the redirect_url_overrides field was set successfully');
  }

}
