<?php

/**
 * @file
 * Reports for the Ansers module.
 */

/**
 * Reports orphaned answers.
 *
 * @return string
 *   Orphan report html table.
 */
function answers_orphan_report() {

  module_load_include('inc', 'answers', 'includes/answers.helpers');

  $orphan_nids = _answers_orphan_nids();
  $questions = node_load_multiple($orphan_nids);

  $header = array('Node ID', 'Title', 'Type', 'Created', 'Published');
  $rows = array();
  foreach ($questions as $node) {
    $rows[] = array(
      array('data' => $node->nid, 'align' => 'center'),
      l($node->title, 'node/' . $node->nid . '/edit'),
      $node->type,
      format_date($node->created),
      array('data' => $node->status ? t('Published') : t('Unpublished'), 'class' => $node->status ? 'published' : 'unpublished'),
    );
  }
  $table_attributes = array('id' => 'ralphs-node-table', 'align' => 'center');
  if (count($rows) > 0) {
    return theme('table', array(
      'header' => $header,
      'rows' => $rows,
      'attributes' => $table_attributes,
    ));
  }
  else {
    return '<p>' . t('No orphaned !answers found.', answers_translation()) . '</p>';
  }

}
