<?php

/**
 * @file
 * Helper functions for the Answers module.
 */

/**
 * Implements helper for orphaned answers.
 *
 * @return array
 *   An array of answer nids.
 */
function _answers_orphan_nids() {

  $orphan_nids = array();

  $query = db_select('field_data_answers_related_question', 'q');
  $query->leftJoin('node', 'n', 'q.answers_related_question_target_id = n.nid');

  $query
    ->fields('q', array('entity_id'))
    ->fields('n', array('nid'))
    ->isNull('nid');

  $result = $query->execute();
  foreach ($result as $record) {
    $orphan_nids[] = $record->entity_id;
  }

  $query = db_select('node', 'n');
  $query->leftJoin(
    'field_data_answers_related_question',
    'q',
    'n.nid = q.entity_id'
  );

  $query
    ->fields('q', array('entity_id'))
    ->fields('n', array('nid'))
    ->condition('type', 'answers_answer')
    ->isNull('entity_id');

  $result = $query->execute();
  foreach ($result as $record) {
    $orphan_nids[] = $record->nid;
  }

  return array_unique($orphan_nids);
}
