<?php
/**
 * @file
 * answers_taxonomy.views_default.inc
 */

/**
 * Implements hook_views_default_views().
 */
function answers_taxonomy_views_default_views() {
  $export = array();

  $view = new view();
  $view->name = 'answers_taxonomy_questions_list';
  $view->description = 'Display list of questions for a term';
  $view->tag = 'Answers';
  $view->base_table = 'node';
  $view->human_name = 'Answers Taxonomy Questions List';
  $view->core = 7;
  $view->api_version = '3.0';
  $view->disabled = FALSE; /* Edit this to true to make a default view disabled initially */

  /* Display: Defaults */
  $handler = $view->new_display('default', 'Defaults', 'default');
  $handler->display->display_options['use_more_always'] = FALSE;
  $handler->display->display_options['access']['type'] = 'none';
  $handler->display->display_options['cache']['type'] = 'none';
  $handler->display->display_options['query']['type'] = 'views_query';
  $handler->display->display_options['query']['options']['distinct'] = TRUE;
  $handler->display->display_options['exposed_form']['type'] = 'basic';
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'created' => 'created',
    'entity_id' => 'entity_id',
  );
  $handler->display->display_options['style_options']['default'] = 'created';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 1,
      'default_sort_order' => 'asc',
      'align' => 'views-align-left',
      'separator' => '',
    ),
    'created' => array(
      'sortable' => 1,
      'default_sort_order' => 'desc',
      'align' => 'views-align-center',
      'separator' => '',
    ),
    'entity_id' => array(
      'sortable' => 1,
      'default_sort_order' => 'desc',
      'align' => 'views-align-center',
      'separator' => '',
    ),
  );
  $handler->display->display_options['style_options']['sticky'] = TRUE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<em>No questions created yet for this tag</em>';
  $handler->display->display_options['empty']['area']['format'] = 'filtered_html';
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Question';
  /* Field: Content: Post date */
  $handler->display->display_options['fields']['created']['id'] = 'created';
  $handler->display->display_options['fields']['created']['table'] = 'node';
  $handler->display->display_options['fields']['created']['field'] = 'created';
  $handler->display->display_options['fields']['created']['date_format'] = 'raw time ago';
  /* Field: Content: Answer Count */
  $handler->display->display_options['fields']['entity_id']['id'] = 'entity_id';
  $handler->display->display_options['fields']['entity_id']['table'] = 'field_data_field_answer_count';
  $handler->display->display_options['fields']['entity_id']['field'] = 'field_answer_count';
  $handler->display->display_options['fields']['entity_id']['label'] = 'Answers';
  $handler->display->display_options['fields']['entity_id']['empty'] = 'none';
  $handler->display->display_options['fields']['entity_id']['empty_zero'] = TRUE;
  $handler->display->display_options['fields']['entity_id']['type'] = 'nodereference_count_default';
  /* Contextual filter: Content: Tags (field_answers_taxonomy_terms) */
  $handler->display->display_options['arguments']['field_answers_taxonomy_terms_tid']['id'] = 'field_answers_taxonomy_terms_tid';
  $handler->display->display_options['arguments']['field_answers_taxonomy_terms_tid']['table'] = 'field_data_field_answers_taxonomy_terms';
  $handler->display->display_options['arguments']['field_answers_taxonomy_terms_tid']['field'] = 'field_answers_taxonomy_terms_tid';
  $handler->display->display_options['arguments']['field_answers_taxonomy_terms_tid']['default_action'] = 'default';
  $handler->display->display_options['arguments']['field_answers_taxonomy_terms_tid']['default_argument_type'] = 'taxonomy_tid';
  $handler->display->display_options['arguments']['field_answers_taxonomy_terms_tid']['summary']['number_of_records'] = '0';
  $handler->display->display_options['arguments']['field_answers_taxonomy_terms_tid']['summary']['format'] = 'default_summary';
  $handler->display->display_options['arguments']['field_answers_taxonomy_terms_tid']['summary_options']['items_per_page'] = '25';
  /* Filter criterion: Content: Published */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = '1';
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'question' => 'question',
  );

  /* Display: Answers Taxonomy Term Page View */
  $handler = $view->new_display('page', 'Answers Taxonomy Term Page View', 'page_1');
  $handler->display->display_options['path'] = 'term/questions';
  $export['answers_taxonomy_questions_list'] = $view;

  return $export;
}
