<?php

namespace Drupal\ant_bulk\Drush\Commands;

use Drupal\content_moderation\ModerationInformationInterface;
use Drupal\content_translation\ContentTranslationManagerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Language\LanguageManagerInterface;
use Drush\Attributes as CLI;
use Drush\Commands\DrushCommands;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\ant_bulk\Form\TranslateForm;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\CurrentRouteMatch;
use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * A Drush commandfile.
 */
final class AntBulkCommands extends DrushCommands {

  /**
   * The Translator Form.
   *
   * @var \Drupal\ant_bulk\Form\TranslateForm
   */
  protected $translator;

  /**
   * Constructs an AntBulkCommands object.
   */
  public function __construct(
    private readonly LanguageManagerInterface $languageManager,
    private readonly ConfigFactoryInterface $configFactory,
    private readonly CurrentRouteMatch $routeMatch,
    private readonly TimeInterface $time,
    private readonly AccountProxyInterface $currentUser,
    private readonly ModuleHandlerInterface $moduleHandler,
    private readonly EntityTypeManagerInterface $entityTypeManager,
    private readonly ModerationInformationInterface|NULL $contentModerationModerationInformation,
    private readonly ContentTranslationManagerInterface $contentTranslationManager,
  ) {
    parent::__construct();
    $this->translator = new TranslateForm(
      $languageManager,
      $configFactory,
      $routeMatch,
      $time,
      $currentUser,
      $moduleHandler,
      $entityTypeManager,
      $contentTranslationManager,
      $contentModerationModerationInformation
    );
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('language_manager'),
      $container->get('config.factory'),
      $container->get('current_route_match'),
      $container->get('datetime.time'),
      $container->get('current_user'),
      $container->get('module_handler'),
      $container->get('entity_type.manager'),
      $container->has('content_moderation.moderation_information') ? $container->get('content_moderation.moderation_information') : NULL,
      $container->get('content_translation.manager'),
    );
  }

  /**
   * Translates a content type.
   */
  #[CLI\Command(name: 'ant_bulk:translate', aliases: ['anttrans'])]
  #[CLI\Argument(name: 'type', description: 'Content type machine name to translate.')]
  #[CLI\Argument(name: 'language', description: 'Language id translate.')]
  #[CLI\Option(name: 'overwrite', description: 'Overwrite current translations defaults to false')]
  #[CLI\Option(name: 'size', description: 'Batch size. All if ommited')]

  /**
  * Usage.
  */
  #[CLI\Usage(name: 'ant_bulk:translate', description:  "article fr --overwrite=true size=100")]
  public function translate($type, $language, array $options = [
    'overwrite' => NULL,
    'size' => 0,
  ]) {
    $nodes = $this->translator->getNodes([$type], $options['size'], $options['overwrite'], [$language => 1]);
    $operations[] = [
      [$this->translator, 'translateBatch'],
      [count($nodes), array_values($nodes), [$language => 1], []],
    ];
    $batch = [
      'title' => 'Translating ...',
      'operations' => $operations,
      'finished' => [$this->translator, 'translateFinished'],
    ];
    batch_set($batch);
    drush_backend_batch_process();
  }

}
