<?php

/**
* @file Manages the title change (in all nodes creation form) callback
*/

namespace Drupal\duplicates_warning\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\node\Entity\Node;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\AppendCommand;

class FormAlter {

  public static function autosave(array &$form, FormStateInterface $form_state) {

    // get the title
    $title = $form_state->getValue('title')[0]['value'];

    // algorithme for searching for similar contents

    // Add an Ajax response
    $response = new AjaxResponse();

    // Append a list of found results
    $response->addCommand( new AppendCommand('#dw_container', '<ul><li><a>'.$title.'</a></li></ul>'));

    return $response;

  }

}
