<?php

namespace Drupal\anti_duplicates\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Manages the Coming Soon admin form.
 */
class AntiDuplicatesAdminForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'anti_duplicates_admin_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['anti_duplicates.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {

    $config = $this->config('anti_duplicates.settings');

    $form['anti_duplicates_message'] = [
      '#type' => 'text_format',
      '#title' => $this->t('Message'),
      '#default_value' => $config->get('anti_duplicates_message.value'),
      '#format' => $config->get('anti_duplicates_message.format'),
      '#description' => $this->t("The notice message that shows on the add content page. If not set, a default text will be displayed."),
    ];

    $form['anti_duplicates_form_submission'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Disable form submission'),
      '#description' => $this->t("Disable automatic form submission until you click on 'not a duplicate' button."),
      '#default_value' => $config->get('anti_duplicates_form_submission'),
    ];

    $form['anti_duplicates_search_type'] = [
      '#type' => 'radios',
      '#title' => $this->t('Search type'),
      '#default_value' => $config->get('anti_duplicates_search_type'),
      '#options' => [
        0 => 'Contains a sequence of the title keywords',
        1 => 'Contains the exact title',
        2 => 'Contains any word from the title',
      ],
      '#required' => TRUE,
      '#description' => $this->t("Choose the way Anti-Duplicates search for possible duplicates."),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Get submitted values.
    $values = $form_state->getValues();
    // Save the configuration.
    $this->config('anti_duplicates.settings')
      ->set('anti_duplicates_message', $values['anti_duplicates_message'])
      ->set('anti_duplicates_form_submission', $values['anti_duplicates_form_submission'])
      ->set('anti_duplicates_search_type', $values['anti_duplicates_search_type'])
      ->save();

    // Display success message.
    drupal_set_message($this->t('Anti Duplicates configuration submitted successfully.'), 'status', TRUE);
  }

}
