(function ($, Drupal, drupalSettings) {

  'use strict';

  Drupal.behaviors.anti_duplicates = {
    attach: function (context, settings) {

      // disable form submission inputs when this option is checked.
      if (drupalSettings.anti_duplicates.disable_form) {
        $('.node-form .form-submit').prop('disabled', true);
      }

      /*
      when the link "not a duplicate" is clicked we re-enable the submission
      inputs for the user to be able to submit the form.
       */
      $('#dw-enable-form').on('click', function(e) {
        e.preventDefault();
        $('.node-form .form-submit').prop('disabled', false);
        $(this).fadeIn().addClass('hidden');
      });

      // If there's no result, reactivate form submission
      if ($('#dw-total b').text() == '0') {
        $('.node-form .form-submit').prop('disabled', false);
      }
      
    }
  };

})(jQuery, Drupal, drupalSettings);
