import React from 'react';
import PropTypes from 'prop-types';

import Box from '@material-ui/core/Box';
import Typography from '@material-ui/core/Typography';
import { useTheme } from '@material-ui/core/styles';

import SyncIcon from '@material-ui/icons/Sync';

import './loading-indicator.css';

const LoadingIndicator = ({ isLoading, label }) => {
  const theme = useTheme();

  // Get anu_lms container element and its content generated by Drupal.
  const element = document.getElementById('anu-application');
  const permissions = element?.dataset.permissions ? JSON.parse(element.dataset.permissions) : {};

  return (
    <Box
      display={permissions['restful post anu_lms_lesson_checklist'] ? 'flex' : 'none'}
      data-test="anu-lms-checklist-loading-indicator"
    >
      <SyncIcon
        style={{
          animation: isLoading ? 'rotation 1s linear infinite' : 'none',
          marginRight: theme.spacing(0.5),
        }}
      />

      <Typography variant="body2">{label}</Typography>
    </Box>
  );
};

LoadingIndicator.propTypes = {
  isLoading: PropTypes.bool,
  label: PropTypes.string,
};

LoadingIndicator.defaultProps = {
  isLoading: false,
  label: null,
};

export default LoadingIndicator;
