<?php

namespace Drupal\anu_lms\Event;

use Drupal\node\NodeInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event that is fired when the Lesson service generates data.
 */
class LessonPageDataGeneratedEvent extends Event {

  const EVENT_NAME = 'anu_lms_lesson_page_data_generated';

  /**
   * The page data.
   *
   * @var array
   */
  protected array $pageData;

  /**
   * The node used to generate the data.
   *
   * @var \Drupal\node\NodeInterface
   */
  protected NodeInterface $node;

  /**
   * Constructs the object.
   *
   * @param array $pageData
   *   The data generated by the service.
   * @param \Drupal\node\NodeInterface $node
   *   The node that was used to generate the data.
   */
  public function __construct(array $pageData, NodeInterface $node) {
    $this->pageData = $pageData;
    $this->node = $node;
  }

  /**
   * Get the page data.
   */
  public function getPageData(): array {
    return $this->pageData;
  }

  /**
   * Set the page data.
   */
  public function setPageData(array $data) {
    $this->pageData = $data;
  }

  /**
   * Get the node.
   */
  public function getNode(): NodeInterface {
    return $this->node;
  }

}
