import React from 'react';
import ReactDOM from 'react-dom';

import Application from '@anu/Application';
import CoursesLandingPage from '@anu/pages/coursesLanding';
import { transformCoursesLandingPage } from '@anu/utilities/transform.coursesLanding';

document.addEventListener('DOMContentLoaded', () => {
  // Get courses page element and its content generated by Drupal.
  const element = document.getElementById('anu-application');
  const data = JSON.parse(element.dataset.application);

  ReactDOM.render(
    <Application>
      <CoursesLandingPage {...transformCoursesLandingPage(data)} />
    </Application>,
    element
  );
});
