import React from 'react';
import ReactDOM from 'react-dom';

import Application from '@anu/Application';
import CoursesPage from '@anu/pages/courses';
import { transformCoursesPage } from '@anu/utilities/transform.courses';

document.addEventListener('DOMContentLoaded', () => {
  // Get courses page element and its content generated by Drupal.
  const element = document.getElementById('anu-application');
  const data = JSON.parse(element.dataset.application);

  ReactDOM.render(
    <Application>
      <CoursesPage {...transformCoursesPage(data)} />
    </Application>,
    element
  );
});
