<?php

/**
 * @file
 * anythingslider.admin.inc
 */

  ctools_include('export');
/**
 * AnythingSlider instance settings.
 */
function anythingslider_settings_form() {
  drupal_add_library('system', 'drupal.ajax');
  $build['groups'] = array(
    '#type' => 'vertical_tabs',
  );

  $themes = module_invoke_all('anythingslider_theme_info');
  // Allow theme information to be altered.
  drupal_alter('anythingslider_theme_info', $themes);
  $available_themes = array();
  foreach ($themes as $theme => $properties) {
    $available_themes[$theme] = $properties['name'];
  }
  $instances = ctools_export_crud_load_all('anythingslider');
  // Per instance setting variables.
  foreach ($instances as $instance) {
  $title = $instance->title;
  $sid = $instance->name;
  $build['groups'][$sid] = array(
    '#type' => 'fieldset',
    '#title' => $title,
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
    '#id' => $sid,
  );
  $build['groups'][$sid]['actions'] = array(
    '#type' => 'container',
    '#weight' => 1,
  );
  $build['groups'][$sid]['actions']['save'] = array(
    '#type' => 'markup',
    '#markup' => l(t('Edit'), 'admin/config/user-interface/anythingslider/' . $sid , array('attributes' => array(
      'class' => array('button')
    ))),
    '#weight' => 1,
  );
  $build['groups'][$sid]['actions']['export'] = array(
    '#type' => 'markup',
    '#markup' => l(t('Export'), 'admin/config/user-interface/anythingslider/' . $sid . '/export', array('attributes' => array(
      'class' => array('button')
    ))),
    '#weight' => 2,
  );
  if ($instance->name != 'defualt') {
    $build['groups'][$sid]['actions']['delete'] = array(
      '#type' => 'markup',
      '#markup' => l(t('Delete'), 'admin/config/user-interface/anythingslider/' . $sid . '/delete/nojs', array('attributes' => array(
        'class' => array('button', 'use-ajax')))),
      '#weight' => 3,
    );
  }
  // Details for each instance.
  $build['groups'][$sid]['list'] = anythingslider_instance_details($instance);
  }
  // Add & remove instance settings.
  $build['groups']['anythingslider_settings_add'] = array(
    '#type' => 'fieldset',
    '#title' => t('Add new instance.'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
    '#weight' => -30,
  );
  $build['groups']['anythingslider_settings_add']['name'] = array(
    '#type' => 'textfield',
    '#title' => t('Name'),
    '#description' => t('Name for the instance.'),
    '#required' => TRUE,
  );
  $build['groups']['anythingslider_settings_add']['theme'] = array(
    '#type' => 'select',
    '#title' => t('Theme'),
  '#options' => $available_themes,
    '#description' => t('Select a slider theme.'),
    '#required' => TRUE,
  );
  $build['groups']['anythingslider_settings_add']['actions'] = array(
    '#type' => 'container',
    '#title' => t('Add new instance settings'),
  );
  $build['groups']['anythingslider_settings_add']['actions']['add'] = array(
    '#type' => 'submit',
    '#value' => t('Add Instance'),
    '#submit' => array('anythingslider_settings_add_form_submit'),
  );
  $build['groups']['anythingslider_settings_add']['actions']['import'] = array(
    '#type' => 'markup',
    '#markup' => l(t('Import'), 'admin/config/user-interface/anythingslider/import', array('attributes' => array(
      'class' => array('button')
    ))),
  );
  return $build;
}

/**
 * Implements hook_anythingslider_theme_info().
 */
function anythingslider_anythingslider_theme_info() {
  // anythingslider library path.
  $library_path = libraries_get_path('anythingslider');

  return array(
    'default' => array(
      'name' => t('Default'),
      'description' => t('The default skin for the AnythingSlider.'),
      'thumb_support' => TRUE,
      'resources' => array(
        'css' => array(
          $library_path . '/themes/default.css',
        ),
      ),
    ),
    'minimalist-round' => array(
      'name' => t('Minimalist-Round'),
      'description' => t('Minimalist-Round.'),
      'thumb_support' => FALSE,
      'resources' => array(
        'css' => array(
          $library_path . '/themes/minimalist-round.css',
        ),
      ),
    ),
    'minimalist-square' => array(
      'name' => t('Minimalist-Square'),
      'description' => t('Minimalist-Square.'),
      'thumb_support' => TRUE,
      'resources' => array(
        'css' => array(
          $library_path . '/themes/minimalist-square.css',
        ),
      ),
    ),
    'metallic' => array(
      'name' => t('Metallic'),
      'description' => t('Metallic.'),
      'thumb_support' => TRUE,
      'resources' => array(
        'css' => array(
          $library_path . '/themes/metallic.css',
        ),
      ),
    ),
  'construction' => array(
      'name' => t('Construction'),
      'description' => t('Construction.'),
      'thumb_support' => TRUE,
      'resources' => array(
        'css' => array(
          $library_path . '/themes/construction.css',
        ),
      ),
    ),
  'cs-portfolio' => array(
      'name' => t('CS-Portfolio'),
      'description' => t('CS-Portfolio.'),
      'thumb_support' => TRUE,
      'resources' => array(
        'css' => array(
          $library_path . '/themes/cs-portfolio.css',
        ),
      ),
    ),
  );
}


/**
 * Utility function for generating form - Anythingslider Instance settings .
 */
function anythingslider_instance_elements_form($sid = null, $options = null) {

  isset($sid) ? $mode = 'list' : $mode= 'edit';
  isset($sid) ? $sid : $sid= arg(4);

  $variable = ctools_export_crud_load('anythingslider',$sid);
  $options = $variable->options;

  $form[$sid]['general'] = array(
    '#type' => 'fieldset',
    '#title' => t('General'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['general']['mode'] = array(
    '#type' => 'select',
    '#title' => t('Slide Direction'),
    '#description' => t('Set mode to "horizontal", "vertical" or "fade" (only first letter needed); replaces vertical option'),
    '#options' => array(
      'h'   => t('Horizontal'),
      'vs'  => t('Vertical'),
    'f'  => t('Fade'),
    ),
    '#value' => isset($options['mode']) ? $options['mode'] : _anythingslider_defaults_value('mode'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $easing_opt = array('swing' => t('Swing'), 'linear' => t('Linear'));
  $form[$sid]['general']['easing'] = array(
    '#type' => 'select',
    '#title' => t('Easing'),
    '#multiple' => FALSE,
    '#description' => t('Anything other than "linear" or "swing" requires the easing plugin or jQuery UI'),
    '#options' => $easing_opt,
    '#value' => isset($options['easing']) ? $options['easing'] : _anythingslider_defaults_value('easing'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['general']['controlContainer'] = array(
    '#type' => 'textfield',
    '#title' => t('Control container'),
    '#description' => t('Default container is the slider element. Example use would be ".slider", "#slider" '),
    '#value' => isset($options['controlContainer']) ? $options['controlContainer'] : _anythingslider_defaults_value('controlContainer'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['general']['useCSS'] = array(
    '#type' => 'checkbox',
    '#title' => t('Use CSS'),
    '#description' => t('Slider will use CSS3 transitions, if available.'),
    '#default_value' => isset($options['useCSS']) ? $options['useCSS'] : _anythingslider_defaults_value('useCSS'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance'] = array(
    '#type' => 'fieldset',
    '#title' => t('Appearance'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['appearance']['expand'] = array(
    '#type' => 'checkbox',
    '#title' => t('Expand'),
    '#description' => t('If true, the entire slider will expand to fit the parent element'),
    '#default_value' => isset($options['expand']) ? $options['expand'] : _anythingslider_defaults_value('expand'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['resizeContents'] = array(
    '#type' => 'checkbox',
    '#title' => t('Resize Contents'),
    '#description' => t('If true, solitary images/objects in the panel will expand to fit the viewport'),
    '#default_value' => isset($options['resizeContents']) ? $options['resizeContents'] : _anythingslider_defaults_value('resizeContents'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['showMultiple'] = array(
    '#type' => 'checkbox',
    '#title' => t('showMultiple'),
    '#description' => t(' Set this value to a number and it will show that many slides at once'),
    '#default_value' => isset($options['showMultiple']) ? $options['showMultiple'] : _anythingslider_defaults_value('showMultiple'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['buildArrows'] = array(
    '#type' => 'checkbox',
    '#title' => t('Build Arrows'),
    '#description' => t('If true, builds the forwards and backwards buttons'),
    '#default_value' => isset($options['buildArrows']) ? $options['buildArrows'] : _anythingslider_defaults_value('buildArrows'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['buildNavigation'] = array(
    '#type' => 'checkbox',
    '#title' => t('Build Navigations'),
    '#description' => t('If true, builds a list of anchor links to link to each panel'),
    '#default_value' => isset($options['buildNavigation']) ? $options['buildNavigation'] : _anythingslider_defaults_value('buildNavigation'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['buildStartStop'] = array(
    '#type' => 'checkbox',
    '#title' => t('Build Start Stop'),
    '#description' => t('If true, builds the start/stop button'),
    '#default_value' => isset($options['buildStartStop']) ? $options['buildStartStop'] : _anythingslider_defaults_value('buildStartStop'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
   $form[$sid]['appearance']['toggleArrows'] = array(
    '#type' => 'checkbox',
    '#title' => t('Toggle Arrows'),
    '#description' => t('If true, side navigation arrows will slide out on hovering & hide @ other times'),
    '#default_value' => isset($options['toggleArrows']) ? $options['toggleArrows'] : _anythingslider_defaults_value('toggleArrows'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['toggleControls'] = array(
    '#type' => 'checkbox',
    '#title' => t('Toggle Controls'),
    '#description' => t('if true, slide in controls (navigation + play/stop button) on hover and slide change, hide @ other times'),
    '#default_value' => isset($options['toggleControls']) ? $options['toggleControls'] : _anythingslider_defaults_value('toggleControls'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['startText'] = array(
    '#type' => 'textfield',
    '#title' => t('Start button text'),
    '#description' => t('Set the text for the "Start" state indicator.'),
    '#value' => isset($options['startText']) ? $options['startText'] : _anythingslider_defaults_value('startText'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['stopText'] = array(
    '#type' => 'textfield',
    '#title' => t('Stop button text'),
    '#description' => t('Set the text for the "Stop" state indicator.'),
    '#value' => isset($options['stopText']) ? $options['stopText'] : _anythingslider_defaults_value('stopText'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['forwardText'] = array(
    '#type' => 'textfield',
    '#title' => t('Forward button text'),
    '#description' => t('Link text used to move the slider forward (hidden by CSS, replaced with arrow image)'),
    '#value' => isset($options['forwardText']) ? $options['forwardText'] : _anythingslider_defaults_value('forwardText'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['backText'] = array(
    '#type' => 'textfield',
    '#title' => t('Back button text'),
    '#description' => t('Link text used to move the slider back (hidden by CSS, replace with arrow image)'),
    '#value' => isset($options['backText']) ? $options['backText'] : _anythingslider_defaults_value('backText'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['appearance']['tooltipClass'] = array(
    '#type' => 'textfield',
    '#title' => t('Tool tip Class'),
    '#description' => t('Class added to navigation & start/stop button (text copied to title if it is hidden by a negative text indent'),
    '#value' => isset($options['tooltipClass']) ? $options['tooltipClass'] : _anythingslider_defaults_value('tooltipClass'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['function'] = array(
    '#type' => 'fieldset',
    '#title' => t('Function'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['function']['enableArrows'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enable Arrows'),
    '#description' => t('if false, arrows will be visible, but not clickable.'),
    '#default_value' => isset($options['enableArrows']) ? $options['enableArrows'] : _anythingslider_defaults_value('enableArrows'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['function']['enableNavigation'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enable Navigation'),
    '#description' => t('if false, navigation links will still be visible, but not clickable.'),
    '#default_value' => isset($options['enableNavigation']) ? $options['enableNavigation'] : _anythingslider_defaults_value('enableNavigation'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['function']['enableStartStop'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enable StartStop'),
    '#description' => t('if false, the play/stop button will still be visible, but not clickable. Previously "enablePlay"'),
    '#default_value' => isset($options['enableStartStop']) ? $options['enableStartStop'] : _anythingslider_defaults_value('enableStartStop'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['function']['enableKeyboard'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enable Keyboard'),
    '#description' => t('if false, keyboard arrow keys will not work for this slider.'),
    '#default_value' => isset($options['enableKeyboard']) ? $options['enableKeyboard'] : _anythingslider_defaults_value('enableKeyboard'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['navigation'] = array(
    '#type' => 'fieldset',
    '#title' => t('Navigation'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['navigation']['startPanel'] = array(
    '#type' => 'textfield',
    '#title' => t('Start Panel'),
    '#description' => t('This sets the initial panel'),
    '#value' => isset($options['startPanel']) ? $options['startPanel'] : _anythingslider_defaults_value('startPanel'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
   $form[$sid]['navigation']['changeBy'] = array(
    '#type' => 'textfield',
    '#title' => t('Change By'),
    '#description' => t('Amount to go forward or back when changing panels.'),
    '#value' => isset($options['changeBy']) ? $options['changeBy'] : _anythingslider_defaults_value('changeBy'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
   $form[$sid]['navigation']['hashTags'] = array(
    '#type' => 'checkbox',
    '#title' => t('Hash Tags'),
    '#description' => t('Should links change the hashtag in the URL?'),
    '#default_value' => isset($options['hashTags']) ? $options['hashTags'] : _anythingslider_defaults_value('hashTags'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['navigation']['infiniteSlides'] = array(
    '#type' => 'checkbox',
    '#title' => t('Infinite Slides'),
    '#description' => t('if false, the slider will not wrap & not clone any panels.'),
    '#default_value' => isset($options['infiniteSlides']) ? $options['infiniteSlides'] : _anythingslider_defaults_value('infiniteSlides'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['navigation']['navigationSize'] = array(
    '#type' => 'checkbox',
    '#title' => t('Navigation Size'),
    '#description' => t('Set this to the maximum number of visible navigation tabs; false to disable'),
    '#default_value' => isset($options['navigationSize']) ? $options['navigationSize'] : _anythingslider_defaults_value('navigationSize'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['slideshow_options'] = array(
    '#type' => 'fieldset',
    '#title' => t('Slideshow options'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['slideshow_options']['autoPlay'] = array(
    '#type' => 'checkbox',
    '#title' => t('Auto Play'),
    '#description' => t('If true, the slideshow will start running; replaces "startStopped" option'),
    '#default_value' => isset($options['autoPlay']) ? $options['autoPlay'] : _anythingslider_defaults_value('autoPlay'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['slideshow_options']['autoPlayLocked'] = array(
    '#type' => 'checkbox',
    '#title' => t('Auto Play Locked'),
    '#description' => t('If true, user changing slides will not stop the slideshow'),
    '#default_value' => isset($options['autoPlayLocked']) ? $options['autoPlayLocked'] : _anythingslider_defaults_value('autoPlayLocked'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['slideshow_options']['autoPlayDelayed'] = array(
    '#type' => 'checkbox',
    '#title' => t('Auto Play Delayed'),
    '#description' => t('If true, starting a slideshow will delay advancing slides; if false, the slider will immediately advance to the next slide when slideshow starts'),
    '#default_value' => isset($options['autoPlayDelayed']) ? $options['autoPlayDelayed'] : _anythingslider_defaults_value('autoPlayDelayed'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['slideshow_options']['pauseOnHover'] = array(
    '#type' => 'checkbox',
    '#title' => t('Pause On Hover'),
    '#description' => t('If true & the slideshow is active, the slideshow will pause on hover'),
    '#default_value' => isset($options['pauseOnHover']) ? $options['pauseOnHover'] : _anythingslider_defaults_value('pauseOnHover'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['slideshow_options']['stopAtEnd'] = array(
    '#type' => 'checkbox',
    '#title' => t('Stop At End'),
    '#description' => t('If true & the slideshow is active, the slideshow will stop on the last page. This also stops the rewind effect when infiniteSlides is false.'),
    '#default_value' => isset($options['stopAtEnd']) ? $options['stopAtEnd'] : _anythingslider_defaults_value('stopAtEnd'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['slideshow_options']['playRtl'] = array(
    '#type' => 'checkbox',
    '#title' => t('Move right to left'),
    '#description' => t('If true, the slideshow will move right-to-left'),
    '#default_value' => isset($options['playRtl']) ? $options['playRtl'] : _anythingslider_defaults_value('playRtl'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['times'] = array(
    '#type' => 'fieldset',
    '#title' => t('Times'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['times']['delay'] = array(
    '#type' => 'textfield',
    '#title' => t('Delay'),
    '#description' => t('How long between slideshow transitions in AutoPlay mode (in milliseconds)'),
    '#value' => isset($options['delay']) ? $options['delay'] : _anythingslider_defaults_value('delay'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['times']['resumeDelay'] = array(
    '#type' => 'textfield',
    '#title' => t('Resume Delay'),
    '#description' => t('Resume slideshow after user interaction, only if autoplayLocked is true (in milliseconds).'),
    '#value' => isset($options['resumeDelay']) ? $options['resumeDelay'] : _anythingslider_defaults_value('resumeDelay'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['times']['animationTime'] = array(
    '#type' => 'textfield',
    '#title' => t('Animation Time'),
    '#description' => t('How long the slideshow transition takes (in milliseconds).'),
    '#value' => isset($options['animationTime']) ? $options['animationTime'] : _anythingslider_defaults_value('animationTime'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['times']['delayBeforeAnimate'] = array(
    '#type' => 'textfield',
    '#title' => t('Delay Before Animate'),
    '#description' => t('How long to pause slide animation before going to the desired slide (used if you want your "out" FX to show).'),
    '#value' => isset($options['delayBeforeAnimate']) ? $options['delayBeforeAnimate'] : _anythingslider_defaults_value('delayBeforeAnimate'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['callbacks'] = array(
    '#type' => 'fieldset',
    '#title' => t('Callbacks'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['callbacks']['onBeforeInitialize'] = array(
    '#type' => 'textfield',
    '#title' => t('onBeforeInitialize'),
    '#description' => t('Callback before the plugin initializes'),
    '#value' => isset($options['onBeforeInitialize']) ? $options['onBeforeInitialize'] : _anythingslider_defaults_value('onBeforeInitialize'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['callbacks']['onSlideBegin'] = array(
    '#type' => 'textfield',
    '#title' => t('onSlideBegin'),
    '#description' => t('Callback before slide animates'),
    '#value' => isset($options['onSlideBegin']) ? $options['onSlideBegin'] : _anythingslider_defaults_value('onSlideBegin'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
   $form[$sid]['callbacks']['onSlideComplete'] = array(
    '#type' => 'textfield',
    '#title' => t('onSlideComplete'),
    '#description' => t('Callback when slide completes; this is the only callback without an event "e" parameter'),
    '#value' => isset($options['onSlideComplete']) ? $options['onSlideComplete'] : _anythingslider_defaults_value('onSlideComplete'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['interactivity'] = array(
    '#type' => 'fieldset',
    '#title' => t('Interactivity'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['interactivity']['clickForwardArrow'] = array(
    '#type' => 'textfield',
    '#title' => t('Click Forward Arrow'),
    '#description' => t('Event used to activate forward arrow functionality (e.g. add jQuery mobile swiperight.)'),
    '#value' => isset($options['clickForwardArrow']) ? $options['clickForwardArrow'] : _anythingslider_defaults_value('clickForwardArrow'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['interactivity']['clickBackArrow'] = array(
    '#type' => 'textfield',
    '#title' => t('Click Back Arrow'),
    '#description' => t('Event used to activate back arrow functionality(e.g. add jQuery mobile swipeleft.)'),
    '#value' => isset($options['clickBackArrow']) ? $options['clickBackArrow'] : _anythingslider_defaults_value('clickBackArrow'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['interactivity']['clickControls'] = array(
    '#type' => 'textfield',
    '#title' => t('Click Controls'),
    '#description' => t('Events used to activate navigation control functionality'),
    '#value' => isset($options['clickControls']) ? $options['clickControls'] : _anythingslider_defaults_value('clickControls'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['interactivity']['clickSlideshow'] = array(
    '#type' => 'textfield',
    '#title' => t('Click Slideshow'),
    '#description' => t('Event used to activate slideshow play/stop button'),
    '#value' => isset($options['clickSlideshow']) ? $options['clickSlideshow'] : _anythingslider_defaults_value('clickSlideshow'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['interactivity']['allowRapidChange'] = array(
    '#type' => 'checkbox',
    '#title' => t('Allow Rapid Change'),
    '#description' => t('If true, allow rapid changing of the active pane, instead of ignoring activity during animation.'),
    '#default_value' => isset($options['allowRapidChange']) ? $options['allowRapidChange'] : _anythingslider_defaults_value('allowRapidChange'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['video'] = array(
    '#type' => 'fieldset',
    '#title' => t('Video'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  $form[$sid]['video']['resumeOnVideoEnd'] = array(
    '#type' => 'checkbox',
    '#title' => t('Resume On Video End'),
    '#description' => t('If true & the slideshow is active & a supported video is playing, it will pause the autoplay until the video is complete'),
    '#default_value' => isset($options['resumeOnVideoEnd']) ? $options['resumeOnVideoEnd'] : _anythingslider_defaults_value('resumeOnVideoEnd'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );

  $form[$sid]['video']['resumeOnVisible'] = array(
    '#type' => 'checkbox',
    '#title' => t('Resume On Visible'),
    '#description' => t('If true the video will resume playing (if previously paused, except for YouTube iframe - known issue); if false, the video remains paused.'),
    '#default_value' => isset($options['resumeOnVisible']) ? $options['resumeOnVisible'] : _anythingslider_defaults_value('resumeOnVisible'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );
  $form[$sid]['video']['addWmodeToObject'] = array(
    '#type' => 'textfield',
    '#title' => t('Add Wmode To Object'),
    '#description' => t('How long to pause slide animation before going to the desired slide (used if you want your "out" FX to show).'),
    '#value' => isset($options['addWmodeToObject']) ? $options['addWmodeToObject'] : _anythingslider_defaults_value('addWmodeToObject'),
    '#disabled' => ($mode == 'edit') ? false : true,
  );

  if($mode == 'edit') {
    $form[$sid]['submit']  = array(
      '#type' => 'submit',
      '#value' => t('Update Instance'),
    );
  }

  return $form;
}

/**
 * Implemented hook_form_submit
 */
function anythingslider_instance_settings_update_form($form, &$form_state) {
  $form =  anythingslider_instance_elements_form();
  return $form;
}

/**
 * Implemented hook_form_submit
 */
function anythingslider_instance_settings_update_form_submit($form, &$form_state) {
  $variable = ctools_export_crud_load('anythingslider',arg(4));
  $variable->options = $form_state['input'];
  ctools_export_crud_save('anythingslider', $variable);
  drupal_goto('admin/config/user-interface/anythingslider');
}

/**
 * Utility function to extract instance specifc details
 */
function anythingslider_instance_details($instance){
  $sid = $instance->name;
  $options = array();
  $variable = ctools_export_crud_load('anythingslider',$sid);
  if($variable) {
    $options = ($variable->options);
  }
  return  anythingslider_instance_elements_form($sid, $options);
}


/**
 * Menu callback, export Anythingslider instance settings.
 */
function anythingslider_export_instance_settings($instance) {
  require_once(DRUPAL_ROOT . '/includes/utility.inc');
  $variables = _anythingslider_return_instance_settings($instance);
  $form['container'] = array(
    '#type' => 'fieldset',
    '#title' => t('Settings Export'),
  );
  $form['container']['export'] = array(
    '#type' => 'textarea',
    '#rows' => 10,
    '#value' => $variables,
    '#description' => t('List of anythingslider instance setting variables.'),
  );

  return $form;
}

/**
 * Menu callback, delete Anythingslider instance settings.
 */
function anythingslider_delete_instance_settings($id = null, $js) {
  $message = t('AnythingSlider instace @id could not be found.', array('@id' => $id));
  if ($id) {

     $instance_group = ctools_export_crud_load('anythingslider', $id);
     ctools_export_crud_delete('anythingslider', $instance_group);

    $message = t('AnythingSlider instace @id has been deleted.', array('@id' => $id));

    if ($js == 'ajax') {
      $message = drupal_set_message($message, 'status');

      $commands = array();
      $commands[] = ajax_command_remove('#' . $id);
      $commands[] = ajax_command_remove('#anythingslider-settings-form .vertical-tab-button.selected');
      $commands[] = ajax_command_prepend('#page', theme('status_messages', $message));
      $page = array('#type' => 'ajax', '#commands' => $commands);
      ajax_deliver($page);
      exit;
    }
  }
  else {
    drupal_set_message(t("There was an error deleting AnythingSlider Instance : '%dgid'.", array('%dgid' => check_plain($id))));
  }

  drupal_set_message($message, 'status');
  // Return user to settings overview.
  drupal_goto('admin/config/user-interface/anythingslider');
}

/**
 * Implementation of hook_form
 */
function anythingslider_instance_settings_import_form($form, $form_state) {
 $form['container'] = array(
    '#type' => 'fieldset',
    '#title' => t('Settings Import'),
  );
  $form['container']['name'] = array(
    '#type' => 'textfield',
    '#title' => t('Name'),
    '#description' => t('Identifier for group of settings.'),
    '#required' => TRUE,
  );
  $form['container']['import'] = array(
    '#type' => 'textarea',
    '#description' => t('Paste JSON of instance setting'),
    '#rows' => 10,
  );
  $form['actions'] = array(
    '#type' => 'container',
    '#title' => t('Add new instance settings group'),
  );
  // @todo, validation.
  $form['actions']['add'] = array(
    '#type' => 'submit',
    '#value' => t('Add group'),
  );

  return $form;
}

/**
 * Submit handler, Anythingslider instance settings form import.
 */
function anythingslider_instance_settings_import_form_submit($form, $form_state) {
  $message = t('Name already exists as group of settings identifier.');
  $result = FALSE;
  // Readable name.
  $name = $form_state['values']['name'];

  // Machine name.
  $instance_name = drupal_clean_css_identifier(drupal_strtolower($name));

  $instance = ctools_export_crud_load('anythingslider', $instance_name);

  if (empty($instance) ) {
    $message = t('New group @name has been added.', array('@name' => $name));
    $record = array('name'=>'anythingslider_'.$instance_name,  'title' => $name, 'theme' => 'default', 'options' => $form_state['values']['import']);
    drupal_write_record('anythingslider', $record );
  }
  else {
    $message = t('Instance @name already exists.', array('@name' => $name));
  }
  drupal_set_message($message, 'status');
}
