<?php
/**
 * @file
 * Contains the base row style plugin.
 */

/**
  * Implements a style type plugin for the Views module.
  */
class anythingslider_views_plugin_style_anythingslider extends views_plugin_style {
  public function option_definition() {
    $options = parent::option_definition();
    $options['options'] = array('default' => '');
	$options['selector_type'] = array('default' => '');
    $options['selector'] = array('default' => '');
    return $options;
  }
  public function options_form(&$form, &$form_state) {
    parent::options_form($form, $form_state);
	foreach (anythingslider_instance_load_all()  as $instance) {
	  $name = $instance->name;
	  $all_instances[$name] = check_plain($instance->title);
	}
	$form['anythingslider'] = array(
      '#type' => 'fieldset',
      '#title' => t('AnythingSlider'),
    );
	$form['anythingslider']['instances'] = array(
      '#title' => t('Select Instance'),
      '#type' => 'select',
      '#options' => $all_instances,
      '#default_value' => $this->options['instances'],
    );
	$form['anythingslider']['selector_type'] = array(
      '#title' => t('Selector type'),
      '#type' => 'select',
      '#options' => array('id' => t('Id'), 'class' => t('Class')),
      '#default_value' => $this->options['selector_type'],
    );
	$form['anythingslider']['selector'] = array(
      '#type' => 'textfield',
      '#title' => t('Selector'),
      '#description' => t("Define the anythingslider container"),
      '#size' => 40,
      '#maxlength' => 255,
      '#default_value' => $this->options['selector'],
    );

}

 /**
   * Saved instance.
   */
  function options_submit(&$form, &$form_state) {
    $settings = $form_state['values']['style_options'];
    $config = array_merge($settings['anythingslider']);
    $form_state['values']['style_options'] = $config;
  }
  
  /**
   * Render display.
   */
  function render() {
  //  $id = 'anythingslider-' . $this->view->current_display . $this->view->vid;
   // $this->options['id'] = $id;
    // Group results.
    $rows = $this->render_grouping($this->view->result, $this->options['grouping']);
    $output = '';
    foreach ($rows as $title => $row) {
      $output .= theme($this->theme_functions(),
        array(
          'view' => $this->view,
          'options' => $this->options,
          'rows' => $row,
          'title' => $title
        )
      );
    }
    return $output;
  }
}