<?php
/**
 * @file
 * anythingslider.theme.inc
 *
 * Implements theme functions for AnythingSlider.
 */


/**
 * Theme implementation for anythingslider_list
 */
function theme_anythingslider_list(&$vars) {
  $instances = &$vars['settings']['instances'];
  $items = &$vars['items'];
  $attributes = &$vars['settings']['attributes'];
  $type = &$vars['settings']['type'];
  $output = '';

  if (!empty($items)) {
    $output .= "<$type" . drupal_attributes($attributes) . '>';
    foreach ($items as $i => $item) {
      $output .= theme('anythingslider_list_item', array(
        'item' => $item['slide'],
        'settings' => array(
          'instances' => $instances,
        ),
      ));
    }
    $output .= "</$type>";
  }

  return $output;
}

/**
 * Theme implementation for anythingslider_list_item
 */
function theme_anythingslider_list_item(&$vars) {
  return '<li' . drupal_attributes($vars['settings']['attributes']) . '>' . $vars['item'] . "</li>\n";
}

/**
 * Template preprocess handler for anythingslider theme.
 */
function template_process_anythingslider(&$vars) {

  $instance = &$vars['settings']['instances'];
  $settings = &$vars['settings'];
  $items = &$vars['items'];
  if (empty($settings['type'])) {
    $settings['type'] = 'ul';
  }
  if (!empty($instance)) {
    $instance = anythingslider_instance_load($instance);
  }
  $attributes = array();
  if (isset($settings['attributes']) and is_array($settings['attributes'])) {
    $attributes += $settings['attributes'];
  }
 // $attributes['class'][] = 'anythingslider';

  $settings['attributes'] = $attributes;
  anythingslider_load_js($vars['settings']['attributes']['selector_type'], $vars['settings']['attributes']['selector'], $vars['settings']['instances']);
}

/**
 * Function for anythingslider_list_item
 */
function template_process_anythingslider_list(&$vars) {
  $vars['settings']['attributes'] = array(
    $vars['settings']['attributes']['selector_type'] => $vars['settings']['attributes']['selector'],
  );
}

/**
 * Function for anythingslider_list_item
 */
function template_process_anythingslider_list_item(&$vars) {
  $vars['settings']['attributes'] = array();
  $item = &$vars['item'];
  $settings = &$vars['settings'];
  $attributes = &$vars['settings']['attributes'];
}
