// $Id: apachesolr_ajax.js,v 1.2 2009/10/16 22:37:10 jpmckinney Exp $

var Manager;

Drupal.behaviors.apachesolr_ajax = function (context) {
  if (!Drupal.settings.apachesolr_ajax.initialized) {
    Drupal.settings.apachesolr_ajax.initialized = true;

    // Create a manager instance of the class specified.
    var managerClass = Drupal.settings.apachesolr_ajax.manager.managerclass;
    if (AjaxSolr[managerClass]) {
      Manager = new AjaxSolr[managerClass](Drupal.settings.apachesolr_ajax.manager);
    }

    for (var i in Drupal.settings.apachesolr_ajax.widgets) {
      // Create instances of the widgets specified
      var widgetClass = Drupal.settings.apachesolr_ajax.widgets[i].widgetclass;
      if (AjaxSolr[widgetClass]) {
        Manager.addWidget(new AjaxSolr[widgetClass](Drupal.settings.apachesolr_ajax.widgets[i]));
      }
    }

    Manager.init();

    // changes to Apache Solr's default UI
    jQuery('img.sort').remove();
  }
}

/**
 * Shows the element if the condition is true.
 *
 * @param condition The condition.
 */
$.fn.showIf = function (condition) {
  if (condition) {
    this.show();
  }
  else {
    this.hide();
  }
}
