// $Id: apachesolr_ajax.js,v 1.6 2010/03/15 16:48:38 jpmckinney Exp $

Drupal.behaviors.apachesolr_ajax = function (context) {
  if (Drupal.settings.apachesolr_ajax) {
    var blocks  = Drupal.settings.apachesolr_ajax.blocks;
    var content = Drupal.settings.apachesolr_ajax.content;
    var regions = Drupal.settings.apachesolr_ajax.regions;
    var spinner = Drupal.settings.apachesolr_ajax.spinner;

    function apachesolr_ajax_url_to_state(url) {
      return url.replace(/.*\/search\/apachesolr_\w+/, '');
    }

    function apachesolr_ajax_request_callback(state) {
      if (spinner) {
        if (content) {
          $(content).html($('<img/>').attr('src', spinner));
        }
      }
      $.post('/search/apachesolr_ajax' + state, { js: 1 }, apachesolr_ajax_response_callback, 'json');
    }

    function apachesolr_ajax_response_callback(data) {
      if (blocks) {
        for (var block in blocks) {
          $(blocks[block]).remove();
        }
      }
      for (var region in data) {
        if (region == 'apachesolr_ajax') {
          if (content) {
            $(content).html(data[region]);
          }
        }
        else {
          for (var block in data[region]) {
            if (regions[region] && blocks[block]) {
              $(regions[region]).append(data[region][block]);
            }
          }
        }
      }

      // @see apachesolr.js
      Drupal.behaviors.apachesolr(document);
    }

    function apachesolr_ajax_navigate(url) {
      var state = apachesolr_ajax_url_to_state(url);
      try {
        YAHOO.util.History.navigate('q', state);
      }
      catch (e) {
        apachesolr_ajax_request_callback(state);
      }
      return false;
    }

    function apachesolr_ajax(selector) {
      $(selector + ' a[href*=/search/apachesolr_]').livequery('click', function () {
        return apachesolr_ajax_navigate($(this).attr('href'));
      });
      $(selector + ' form[action*=/search/apachesolr_]').livequery('submit', function () {
        return apachesolr_ajax_navigate('/' + $('#edit-keys').val()); // @todo Add support for retain-filters.
      });
    }

    var initialState = YAHOO.util.History.getBookmarkedState('q') || apachesolr_ajax_url_to_state(window.location.href);
    YAHOO.util.History.register('q', initialState, apachesolr_ajax_request_callback);

    YAHOO.util.History.onReady(function () {
      if (content) {
        apachesolr_ajax(content);
      }
      if (blocks) {
        for (var block in blocks) {
          apachesolr_ajax(blocks[block]);
        }
      }
      var currentState = YAHOO.util.History.getCurrentState('q');
      apachesolr_ajax_request_callback(currentState);
    });

    try {
      YAHOO.util.History.initialize('yui-history-field', 'yui-history-iframe');
    }
    catch (e) {
      apachesolr_ajax_request_callback(initialState);
    }
  }
}
