<?php

/**
 * @file
 *  TODO
 */

/**
 * Implements hook_variable_group_info().
 */
function apachesolr_confgen_textfiles_variable_group_info() {
  $groups['apachesolr_confgen_textfiles'] = array(
    'title' => t('Apache Solr Text Files'),
    'description' => t('Adjustable advanced parameters of the configuration files generated by Apache Solr Config Generator module'),
    'access' => 'administer search',
    'path' => array('admin/config/search/apachesolr/textfiles'),
  );

  return $groups;
}

/**
 * Implements hook_variable_info().
 */
function apachesolr_confgen_textfiles_variable_info($options) {
  $path = drupal_get_path('module', 'apachesolr_confgen_textfiles') . '/res/';

  $variables['apachesolr_confgen_textfiles_stopwords_txt'] = array(
    'type' => 'text',
    'title' => 'stopwords.txt', // file name must not be translated because it's used by some code
    'default' => file_get_contents($path . 'stopwords.txt'),
    'description' => t('Words not included in the index.', array(), $options),
    'group' => 'apachesolr_confgen_textfiles',
  );

  $variables['apachesolr_confgen_textfiles_protwords_txt'] = array(
    'type' => 'text',
    'title' => 'protwords.txt', // file name must not be translated because it's used by some code
    'default' => apachesolr_confgen_load_config_file(apachesolr_confgen_get_local_path('3.5.x') . 'protwords.txt'),
    'description' => t('Use a protected word file to protect against the stemmer reducing two unrelated words to the same base word.', array(), $options),
    'group' => 'apachesolr_confgen_textfiles',
  );

  $variables['apachesolr_confgen_textfiles_synonyms_txt'] = array(
    'type' => 'text',
    'title' => 'synonyms.txt', // file name must not be translated because it's used by some code
    'default' => file_get_contents($path . 'synonyms.txt'),
    'description' => t('Synonyms.', array(), $options),
    'group' => 'apachesolr_confgen_textfiles',
  );

  $variables['apachesolr_confgen_textfiles_compoundwords_txt'] = array(
    'type' => 'text',
    'title' => 'compoundwords.txt', // file name must not be translated because it's used by some code
    'default' => '', // TODO
    'description' => t('Compound words.', array(), $options),
    'group' => 'apachesolr_confgen_textfiles',
  );

  $variables['apachesolr_confgen_textfiles_mapping_isolatin1accent_txt'] = array(
    'type' => 'text',
    'title' => 'mapping-ISOLatin1Accent.txt', // file name must not be translated because it's used by some code
    'default' => file_get_contents($path . 'mapping-ISOLatin1Accent.txt'),
    'description' => t('This map converts accented characters into their ASCII equivalents without accents', array(), $options),
    'group' => 'apachesolr_confgen_textfiles',
  );

  $variables['apachesolr_confgen_textfiles_admin_extra_html'] = array(
    'type' => 'text',
    'title' => 'admin-extra.html', // file name must not be translated because it's used by some code
    'default' => file_get_contents($path . 'admin-extra.html'),
    'description' => t('The content of this page will be statically included into the top of the admin page.', array(), $options),
    'group' => 'apachesolr_confgen_textfiles',
  );

  return $variables;
}
