<?php
// $Id: apachesolr_multilingual.admin.inc,v 1.3.2.4 2010/04/27 14:16:57 mkalkbrenner Exp $

/**
 * @file
 * Admin settings for Apache Solr Multilingual.
 *
 * @see apachesolr_multilingual.module
 * @see apachesolr.module
 *
 * @author Markus Kalkbrenner (mkalkbrenner) | Cocomore AG
 *   @see http://drupal.org/user/124705
 *   @see http://drupal.cocomore.com
 */

function apachesolr_multilingual_admin_form($form_state) {
  $active_languages = locale_language_list();

  foreach ($active_languages as $id => $language) {
    if (!apachesolr_multilingual_get_stemmer($id)) {
      $active_languages[$id] .= ' ' . t('(without stemming)');
    }
  }

  $form['apachesolr_multilingual_index_translations'] = array(
    '#type' => 'checkbox',
    '#title' => t('Index node translations'),
    '#default_value' => variable_get('apachesolr_multilingual_index_translations', 0),
    '#description' => t('All translations of a node will be added to the node itself.'),
  );

  $form['apachesolr_multilingual_index_term_translations'] = array(
    '#type' => 'checkbox',
    '#title' => t('Index taxonomy term translations'),
    '#default_value' => variable_get('apachesolr_multilingual_index_term_translations', 0),
    '#description' => t('Index translations of the taxonomy terms. Requires module Taxonomy Translation which is part of !link.', array('!link' => l('Internationalization', 'http://drupal.org/project/i18n'))),
  );

  $form['apachesolr_multilingual_languages'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Languages'),
    '#options' => $active_languages,
    '#default_value' => variable_get('apachesolr_multilingual_languages', array()),
    '#description' => t('Select languages to be handled by multilingual search. You can only choose from languges actived !link.', array('!link' => l(t('here'), 'admin/settings/language'))),
  );

  $form['apachesolr_multilingual_map_language_neutral'] = array(
    '#type' => 'radios',
    '#title' => t('Map language neutral'),
    '#options' => array_merge(array('' => t('No mapping')), $active_languages),
    '#default_value' => variable_get('apachesolr_multilingual_map_language_neutral', ''),
    '#description' => t('Select a language to treat content marked as language neutral.'),
  );

  return system_settings_form($form);
}
