<?php
// $Id: apachesolr_multilingual.schema_generator.inc,v 1.7.2.4 2010/04/26 14:54:37 mhuder Exp $

/**
 * @file
 * Schema generator for multilingual search
 *
 * @see apachesolr_multilingual.module
 * @see apachesolr.module
 *
 * @author Matthias Huder (mhuder) | Cocomore AG
 *   @see http://drupal.org/user/753332
 *   @see http://drupal.cocomore.com
 *
 * @author Markus Kalkbrenner (mkalkbrenner) | Cocomore AG
 *   @see http://drupal.org/user/124705
 *   @see http://drupal.cocomore.com
 */


/**
 * Implements hook_form().
 *
 * @param unknown_type $form_state
 * @return unknown_type
 */
function apachesolr_multilingual_schema_generator_form($form_state) {
  $active_languages = locale_language_list();
  $selected_languages = variable_get('apachesolr_multilingual_languages', array());
  $language_count = 0;
  foreach($selected_languages as $lang) {
    if ($lang) {
      $language_count++;
    }
  }
  if ($language_count < 1) {
    $form['info'] = array(
    '#type' => 'item',
    '#value' => t('No language selected! You have to !link at least one language.', array('!link' => l(t('select'), 'admin/settings/apachesolr/multilingual')))
    );
  } else {
    $form['schema_file_select'] = array(
    '#type' => 'checkboxes',
    '#title' => t('Selected languages'),
    '#options' => $active_languages,
    '#disabled' => true,
    '#default_value' => $selected_languages,
    '#description' => t('Current selected languages to be handled by multilingual search. You can add or remove languages !link.', array('!link' => l(t('here'), 'admin/settings/apachesolr/multilingual'))),
    );
  }
  if ($language_count > 0) {
    if ($language_count == 1 ) {
      $form['set1'] = array(
        '#type' => 'fieldset',
        '#title' => t('Unique (Non-English) Language Configuration Download'),
        '#weight' => 1,
        '#collapsible' => FALSE,
        '#collapsed' => FALSE,
      );

      $form['set1']['submit'] = array(
        '#type' => 'submit',
        '#name' => 'b1',
        '#value' => t('Download !file', array('!file' => 'schema.xml')),
        '#validate' => array('apachesolr_multilingual_schema_generator_form_unique_language_validate'),
      );
      $form['set1']['submitsc'] = array(
        '#type' => 'submit',
        '#name' => 'sc1',
        '#value' => t('Download !file', array('!file' => 'solrconfig.xml')),
        '#validate' => array('apachesolr_multilingual_schema_generator_form_unique_language_validate'),
      );
    }

    $form['set2'] = array(
      '#type' => 'fieldset',
      '#title' => t('Multilingual Configuration Download'),
      '#weight' => 2,
      '#collapsible' => FALSE,
      '#collapsed' => FALSE,
    );
    $form['set2']['submit'] = array(
      '#type' => 'submit',
      '#name' => 'b2',
      '#value' => t('Download !file', array('!file' => 'schema.xml')),
      '#validate' => array('apachesolr_multilingual_schema_generator_form_multilingual_validate'),
    );
    
    $form['set2']['submitsc'] = array(
      '#type' => 'submit',
      '#name' => 'sc2',
      '#value' => t('Download !file', array('!file' => 'solrconfig.xml')),
      '#validate' => array('apachesolr_multilingual_schema_generator_form_multilingual_validate'),
    );
    
    
  }

  $form['#submit'] = array('apachesolr_multilingual_schema_generator_form_submit');

  return $form;
}


function apachesolr_multilingual_schema_generator_form_unique_language_validate(&$form, &$form_state) {
  apachesolr_multilingual_schema_generator_form_do_validate($form, $form_state, FALSE);
}


function apachesolr_multilingual_schema_generator_form_multilingual_validate(&$form, &$form_state) {
  apachesolr_multilingual_schema_generator_form_do_validate($form, $form_state, TRUE);
}


/**
 * Implements hook_form_validate.
 *
 * @param $form
 * @param $form_state
 * @return unknown_type
 */
function apachesolr_multilingual_schema_generator_form_do_validate(&$form, &$form_state, $multilingual) {
  $selected_languages = variable_get('apachesolr_multilingual_languages', array());
  $options = array();
  foreach($selected_languages as $lg) {
    if ($lg) {
      $options[] = $lg;
    }
  }
  
  // schema.xml template file
  $schema_str_complete ='';
  $schema_source_path = dirname(__FILE__) . '/resources/';
  $schema_source_file = $schema_source_path . 'schema.xml';
  $schema_str_complete = file_get_contents($schema_source_file);
  
  // solrconfig.xml template file
  $solrconfig_str_complete ='';
  $solrconfig_source_path = dirname(__FILE__) . '/resources/';
  $solrconfig_source_file = $solrconfig_source_path . 'solrconfig.xml';
  $solrconfig_str_complete = file_get_contents($solrconfig_source_file);
  
  ob_clean();
  ob_start();

  if (!$multilingual) {
    if ($stemmer = apachesolr_multilingual_get_stemmer($options[0])) {
      // adjust stemmer
      $schema_str_complete = str_replace('language="English', 'language="' . $stemmer, $schema_str_complete);
    }
    else {
      // remove stemmer
      $schema_str_complete = preg_replace("/<filter class=\"solr.SnowballPorterFilterFactory\".*$/m", '', $schema_str_complete);
    }
  }
  else {
    // read the block fieldType_text_LANGUAGE.xml
    $schema_source_file = $schema_source_path . 'fieldType_text_LANGUAGE.xml';
    $fieldType_text_LANGUAGE = file_get_contents($schema_source_file);

    // read the block fieldType_text_LANGUAGE.xml
    $schema_source_file = $schema_source_path . 'fieldType_text_no_stemming_LANGUAGE.xml';
    $fieldType_text_no_stemming_LANGUAGE = file_get_contents($schema_source_file);

    // read the block fieldType_textTight_LANGUAGE.xml
    $schema_source_file = $schema_source_path . 'fieldType_textSpell_LANGUAGE.xml';
    $fieldType_textSpell_LANGUAGE = file_get_contents($schema_source_file);

    $blocks = array();
    $blocks['<!-- fieldType_textSpell_LANGUAGE -->'] = $fieldType_textSpell_LANGUAGE;
    $blocks['<!-- field_title_LANGUAGE -->'] = '<field name="title[LANGUAGE_ID]" type="text[LANGUAGE_ID]" indexed="true" stored="true" termVectors="true" omitNorms="true"/>';
    $blocks['<!-- field_body_LANGUAGE -->'] = '<field name="body[LANGUAGE_ID]" type="text[LANGUAGE_ID]" indexed="true" stored="false" termVectors="true"/>';
    $blocks['<!-- field_spell_LANGUAGE -->'] = '<field name="spell[LANGUAGE_ID]" type="textSpell[LANGUAGE_ID]" indexed="true" stored="true" multiValued="true"/>';
    $blocks['<!-- copyField_title_LANGUAGE_spell_LANGUAGE -->'] = '<copyField source="title[LANGUAGE_ID]" dest="spell[LANGUAGE_ID]"/>';
    $blocks['<!-- copyField_body_LANGUAGE_spell_LANGUAGE -->'] = '<copyField source="body[LANGUAGE_ID]" dest="spell[LANGUAGE_ID]"/>';
    $blocks['<!-- field_taxonomy_names_LANGUAGE -->'] = '<field name="taxonomy_names[LANGUAGE_ID]" type="text[LANGUAGE_ID]" indexed="true" stored="false" termVectors="true" multiValued="true" omitNorms="true"/>';
    $blocks['<!-- field_tags_h1_LANGUAGE -->'] = '<field name="tags_h1[LANGUAGE_ID]" type="text[LANGUAGE_ID]" indexed="true" stored="false" omitNorms="true"/>';
    $blocks['<!-- field_tags_h2_h3_LANGUAGE -->'] = '<field name="tags_h2_h3[LANGUAGE_ID]" type="text[LANGUAGE_ID]" indexed="true" stored="false" omitNorms="true"/>';
    $blocks['<!-- field_tags_h4_h5_h6_LANGUAGE -->'] = '<field name="tags_h4_h5_h6[LANGUAGE_ID]" type="text[LANGUAGE_ID]" indexed="true" stored="false" omitNorms="true"/>';
    $blocks['<!-- field_tags_a_LANGUAGE -->'] = '<field name="tags_a[LANGUAGE_ID]" type="text[LANGUAGE_ID]" indexed="true" stored="false" omitNorms="true"/>';
    $blocks['<!-- field_tags_inline_LANGUAGE -->'] = '<field name="tags_inline[LANGUAGE_ID]" type="text[LANGUAGE_ID]" indexed="true" stored="false" omitNorms="true"/>';

    // solrconfig.xml gettablefiles
    $apachesolr_multilingual_filetypes = variable_get('apachesolr_multilingual_filetypes', array('stopwords.txt'=>'stopwords.txt', 'synonyms.txt'=>'synonyms.txt', 'protwords.txt'=>'protwords.txt', 'compoundwords.txt' => 'compoundwords.txt'));
    $gettableFiles = array();
    foreach($apachesolr_multilingual_filetypes as $gettableFile) {
      $gettableFiles[] = str_replace('.txt', '[LANGUAGE_ID].txt', $gettableFile);
    }
    
    $tse = array('[LANGUAGE_NAME]', '[LANGUAGE_ID]');
    // work through the lang.
    foreach ($options as $language) {
      // set the vars to replace in the blocks
      $LANGUAGE_NAME = apachesolr_multilingual_get_stemmer($language);
      $LANGUAGE_ID = '_'.$language;
      $trp = array($LANGUAGE_NAME, $LANGUAGE_ID);

      if ($LANGUAGE_NAME) {
        $blocks['<!-- fieldType_text_LANGUAGE -->'] = $fieldType_text_LANGUAGE;
      }
      else {
        $blocks['<!-- fieldType_text_LANGUAGE -->'] = $fieldType_text_no_stemming_LANGUAGE;
      }
      // schema.xml replace the vars in the blocks
      foreach ($blocks as $search => $replace) {
        $schema_str_complete = str_replace($search, $search."\n".str_replace($tse, $trp, $replace), $schema_str_complete);
      }
      // solrconfig.xml replace the vars in the blocks
      $search = '<!-- gettableFiles_LANGUAGE  -->';
      foreach ($gettableFiles as $s => $replace) {
        $solrconfig_str_complete = str_replace($search, $search."\n".str_replace($tse, $trp, $replace), $solrconfig_str_complete);
      }
    }
  }

  ob_end_clean();

  $form['schema_str_complete']['#type'] = 'value';
  $form['schema_str_complete']['#value'] = $schema_str_complete;

  $form['solrconfig_str_complete']['#type'] = 'value';
  $form['solrconfig_str_complete']['#value'] = $solrconfig_str_complete;
  
  if ($form_state['clicked_button']['#name'] === 'b1' || $form_state['clicked_button']['#name'] === 'b2') {
    drupal_set_header('Content-Type: text/xml; charset=utf-8');
    drupal_set_header('Content-Disposition: attachment; filename=schema.xml');
    print $schema_str_complete;
    exit();
  }

  if ($form_state['clicked_button']['#name'] === 'sc1' || $form_state['clicked_button']['#name'] === 'sc2') {
    drupal_set_header('Content-Type: text/xml; charset=utf-8');
    drupal_set_header('Content-Disposition: attachment; filename=solrconfig.xml');
    print $solrconfig_str_complete;
    exit();
  }
  


}
