/* The following code was generated by JFlex 1.4.1 on 09/07/09 12:58 */

package org.sindice.solr.plugins.analysis;

/**
 * This class is a custom Standard Analyzer for Solr, derived from the Standard
 * Analyzer of Lucene. 
 * ------------------------------------------------------------
 *
 * @project solr-plugins
 *
 * Copyright (C) 2007,
 * @author Renaud Delbru [ 31 janv. 08 ]
 * @link http://renaud.delbru.fr/
 * All rights reserved.
 */

import org.apache.lucene.analysis.Token;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.1
 * on 09/07/09 12:58 from the specification file
 * <tt>/home/renaud/Work/Sindice/workspace/index/index-beta1 [trunk]/src/main/jflex/CustomStandardTokenizerImpl.jflex</tt>
 */
class CustomStandardTokenizerImpl {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\0\1\26\1\0\1\0\1\25\22\0\1\0\1\14\1\0"+
    "\1\12\1\14\1\16\1\3\1\1\1\14\1\14\1\14\1\14\1\15"+
    "\1\5\1\2\1\10\12\20\1\7\1\14\1\0\1\14\1\0\1\11"+
    "\1\4\1\22\1\22\1\22\1\22\1\22\1\22\24\17\4\0\1\6"+
    "\1\0\1\22\1\22\1\22\1\22\1\22\1\22\24\17\3\0\1\13"+
    "\101\0\27\17\1\0\37\17\1\0\u0568\17\12\21\206\17\12\21\u026c\17"+
    "\12\21\166\17\12\21\166\17\12\21\166\17\12\21\166\17\12\21\167\17"+
    "\11\21\166\17\12\21\166\17\12\21\166\17\12\21\340\17\12\21\166\17"+
    "\12\21\u0166\17\12\21\266\17\u0100\17\u0e00\17\u1040\0\u0150\24\140\0\20\24"+
    "\u0100\0\200\24\200\0\u19c0\24\100\0\u5200\24\u0c00\0\u2bb0\23\u2150\0\u0200\24"+
    "\u0465\0\73\24\75\17\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\4\2\1\3\1\1\7\0\2\2\4\0"+
    "\1\4\1\0\2\5\1\0\2\6\4\0\1\7\11\5"+
    "\1\10\3\0\1\10\7\0\2\7\2\10\1\0\1\5"+
    "\1\11\1\7\1\0\1\7\6\0\1\7";

  private static int [] zzUnpackAction() {
    int [] result = new int[71];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\27\0\56\0\105\0\134\0\163\0\27\0\212"+
    "\0\241\0\270\0\317\0\346\0\375\0\u0114\0\u012b\0\u0142"+
    "\0\u0159\0\u0170\0\u0187\0\u019e\0\u01b5\0\u01cc\0\u01e3\0\u01fa"+
    "\0\u0211\0\u0228\0\317\0\u023f\0\u0256\0\u026d\0\u0284\0\u029b"+
    "\0\u02b2\0\u02c9\0\u02e0\0\u02f7\0\u030e\0\u0325\0\u033c\0\u0353"+
    "\0\u036a\0\u0381\0\u0398\0\u03af\0\u03c6\0\u03dd\0\u03f4\0\u040b"+
    "\0\u0422\0\u0439\0\u0450\0\u0467\0\u047e\0\u0495\0\u04ac\0\u04c3"+
    "\0\270\0\u01b5\0\u04da\0\u04f1\0\u0508\0\u051f\0\u0536\0\u054d"+
    "\0\u0564\0\u057b\0\u0592\0\u05a9\0\u05c0\0\u05d7\0\u05ee";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[71];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\17\2\1\3\1\4\1\5\1\3\1\6\1\7\1\10"+
    "\1\2\30\0\1\11\1\12\1\13\1\14\2\15\1\16"+
    "\1\17\4\0\1\17\1\0\1\20\1\4\1\21\1\20"+
    "\1\6\5\0\1\22\1\0\1\23\2\22\1\0\1\24"+
    "\4\0\1\24\1\0\4\4\1\6\4\0\1\11\1\25"+
    "\1\13\1\14\2\22\1\16\1\24\4\0\1\24\1\0"+
    "\1\21\1\4\2\21\1\6\5\0\1\15\1\0\1\23"+
    "\2\15\1\0\1\17\4\0\1\17\1\0\5\6\31\0"+
    "\1\2\17\0\1\26\1\0\2\26\23\0\1\27\1\30"+
    "\1\31\1\27\1\32\22\0\1\33\1\0\2\33\23\0"+
    "\1\34\1\35\2\34\1\35\22\0\1\36\2\30\1\36"+
    "\1\32\5\0\1\37\2\0\2\37\1\0\1\40\2\0"+
    "\1\37\3\0\5\41\22\0\1\17\2\42\1\17\5\0"+
    "\1\11\1\15\1\13\1\14\2\15\1\16\1\17\4\0"+
    "\1\17\1\0\1\20\1\4\1\21\1\20\1\6\4\0"+
    "\1\11\1\22\1\13\1\14\2\22\1\16\1\24\4\0"+
    "\1\24\1\0\1\21\1\4\2\21\1\6\22\0\1\43"+
    "\2\44\1\43\1\45\22\0\5\35\22\0\1\46\2\47"+
    "\1\46\1\50\22\0\1\51\1\44\1\52\1\51\1\45"+
    "\4\0\1\11\15\0\1\26\1\0\2\26\6\0\1\53"+
    "\1\0\1\23\2\54\10\0\1\36\2\30\1\36\1\32"+
    "\5\0\1\55\1\0\1\23\2\55\1\0\1\56\4\0"+
    "\1\56\1\0\4\30\1\32\5\0\1\57\1\0\1\23"+
    "\2\55\1\0\1\56\4\0\1\56\1\0\4\30\1\32"+
    "\5\0\1\54\1\0\1\23\2\54\10\0\5\32\5\0"+
    "\1\60\2\0\1\60\11\0\1\34\1\35\2\34\1\35"+
    "\5\0\1\60\2\0\1\60\11\0\5\35\5\0\1\54"+
    "\1\0\1\23\2\54\10\0\1\36\2\30\1\36\1\32"+
    "\5\0\1\37\1\0\1\61\2\37\1\62\3\0\1\37"+
    "\3\0\5\37\13\0\1\63\20\0\1\64\1\0\1\61"+
    "\1\65\1\37\1\66\2\67\1\70\1\37\3\0\5\41"+
    "\5\0\1\56\2\0\2\56\1\0\1\56\4\0\1\56"+
    "\1\0\4\42\6\0\1\15\1\0\1\23\2\15\1\0"+
    "\1\17\4\0\1\17\1\0\1\43\2\44\1\43\1\45"+
    "\5\0\1\22\1\0\1\23\2\22\1\0\1\24\4\0"+
    "\1\24\1\0\4\44\1\45\5\0\1\15\1\0\1\23"+
    "\2\15\1\0\1\17\4\0\1\17\1\0\5\45\5\0"+
    "\1\17\2\0\2\17\1\0\1\17\4\0\1\17\1\0"+
    "\1\46\2\47\1\46\1\50\5\0\1\24\2\0\2\24"+
    "\1\0\1\24\4\0\1\24\1\0\4\47\1\50\5\0"+
    "\1\17\2\0\2\17\1\0\1\17\4\0\1\17\1\0"+
    "\5\50\5\0\1\71\1\0\1\23\2\15\1\0\1\17"+
    "\4\0\1\17\1\0\1\43\2\44\1\43\1\45\5\0"+
    "\1\72\1\0\1\23\2\22\1\0\1\24\4\0\1\24"+
    "\1\0\4\44\1\45\22\0\1\73\1\32\2\73\1\32"+
    "\22\0\5\32\22\0\5\45\22\0\5\50\22\0\1\74"+
    "\1\45\2\74\1\45\22\0\5\75\22\0\5\76\4\0"+
    "\3\77\1\0\3\77\3\0\3\77\1\0\5\77\5\0"+
    "\1\37\2\0\2\37\4\0\1\37\3\0\5\41\5\0"+
    "\1\37\1\0\1\61\2\37\1\62\3\0\1\37\3\0"+
    "\5\41\5\0\1\37\1\0\1\61\1\65\1\37\1\62"+
    "\3\0\1\37\3\0\5\41\4\0\3\77\1\0\3\77"+
    "\3\0\3\77\1\0\1\77\2\100\2\77\4\0\11\67"+
    "\1\70\3\67\1\101\5\67\4\0\11\70\1\0\3\70"+
    "\1\102\5\70\5\0\1\53\1\0\1\23\2\54\10\0"+
    "\5\32\5\0\1\71\1\0\1\23\2\15\1\0\1\17"+
    "\4\0\1\17\1\0\5\45\5\0\1\60\2\0\1\60"+
    "\11\0\5\75\5\0\1\61\2\0\1\103\1\0\1\104"+
    "\2\67\1\70\4\0\5\76\4\0\3\77\1\61\3\77"+
    "\3\0\3\77\1\0\5\77\4\0\3\77\1\61\3\77"+
    "\2\67\1\70\3\77\1\0\1\77\2\100\2\77\23\0"+
    "\3\105\24\0\3\106\11\0\1\103\11\0\5\76\23\0"+
    "\2\107\25\0\3\67\24\0\3\70\14\0\2\67\1\70"+
    "\5\0\2\107\5\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[1541];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\4\1\1\11\1\1\7\0\2\1\4\0"+
    "\1\1\1\0\2\1\1\0\2\1\4\0\13\1\3\0"+
    "\1\1\7\0\4\1\1\0\3\1\1\0\1\1\6\0"+
    "\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[71];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /* user code: */

public static final int ALPHANUM          = CustomStandardTokenizer.ALPHANUM;
public static final int APOSTROPHE        = CustomStandardTokenizer.APOSTROPHE;
public static final int ACRONYM           = CustomStandardTokenizer.ACRONYM;
public static final int COMPANY           = CustomStandardTokenizer.COMPANY;
public static final int EMAIL             = CustomStandardTokenizer.EMAIL;
public static final int URI             	= CustomStandardTokenizer.URI;
public static final int NUM               = CustomStandardTokenizer.NUM;
public static final int CJ                = CustomStandardTokenizer.CJ;

public static final String [] TOKEN_TYPES = new String [] {
    "<ALPHANUM>",
    "<APOSTROPHE>",
    "<ACRONYM>",
    "<COMPANY>",
    "<EMAIL>",
    "<URI>",
    "<NUM>",
    "<CJ>"
};

public final int yychar()
{
    return yychar;
}

/**
 * Fills Lucene token with the current token text.
 */
final void getText(Token t) {
  t.setTermBuffer(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
}


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  CustomStandardTokenizerImpl(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  CustomStandardTokenizerImpl(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 208) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int getNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = zzLexicalState;


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 8: 
          { return ACRONYM;
          }
        case 10: break;
        case 1: 
          { /* ignore */
          }
        case 11: break;
        case 7: 
          { return URI;
          }
        case 12: break;
        case 5: 
          { return NUM;
          }
        case 13: break;
        case 3: 
          { return CJ;
          }
        case 14: break;
        case 2: 
          { return ALPHANUM;
          }
        case 15: break;
        case 6: 
          { return COMPANY;
          }
        case 16: break;
        case 4: 
          { return APOSTROPHE;
          }
        case 17: break;
        case 9: 
          { return EMAIL;
          }
        case 18: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            return YYEOF;
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
