<?php
// $Id: apachesolr_rdf.admin.inc,v 1.1.2.2 2009/07/24 23:47:19 drunkenmonkey Exp $

/**
 * Function that provides the Apache Solr RDF settings page.
 */
function apachesolr_rdf_settings() {
  // TODO Re-Index button (both global and context-specific)
  // TODO Clean-up button (deletes db data of disabled contexts) - or automatic?
  if (empty($_POST)) {
    $requirements = apachesolr_rdf_requirements('runtime');
    $status = $requirements['apachesolr']['severity'] == REQUIREMENT_ERROR
        ? 'error' : 'status';
    drupal_set_message($requirements['apachesolr']['value'], $status);
  }

  $header = array(t('Indexed'), t('Context URI'), t('Actions'));
  $contexts = variable_get('apachesolr_rdf_contexts', array());
  $rows = array();
  foreach (rdf_get_contexts() as $uri) {
    $rows[] = array(
      isset($contexts[$uri]) && !empty($contexts[$uri]['enabled'])
          ? t('Yes') : t('No'),
      $uri,
      l(t('Edit'), 'admin/settings/apachesolr_rdf/' . urlencode($uri)),
    );
  }
  return theme('table', $header, $rows);
}

/**
 * Function for displaying an "Edit context" form.
 */
function apachesolr_rdf_edit_context_form(&$form_state, $context) {
  $context = _apachesolr_rdf_path_tail(3);
  $form = array();

  $contexts = variable_get('apachesolr_rdf_contexts', array());
  $options = isset($contexts[$context]) ? $contexts[$context] : array();

  $form['prefix'] = array(
    '#value' => '<h3>' .
        t('Editing context @context', array('@context' => $context)) . '</h3>',
  );
  $form['enabled'] = array(
    '#type' => 'checkbox',
    '#title' => t('Enabled'),
    '#description' => t('Sets whether data from this context is indexed.'),
    '#default_value' => !empty($options['enabled']),
  );
  $form['id'] = array(
    '#type' => 'textfield',
    '#title' => t('ID'),
  // TODO: Remember this when implementing searches
    '#description' => t('A short identifier for this context, used internally' .
        ' and in URLs. If you want several contexts to be searched together, ' .
        'specify the same IDs for all of them. However, this will only work, ' .
        'if they are indexed by the same Solr server.'),
    '#default_value' => isset($options['id'])
        ? urldecode($options['id']) : '',
  );
  $form['name'] = array(
    '#type' => 'textfield',
    '#title' => t('Name'),
    '#description' => t('A human-readable name used to point to this context.'),
    '#default_value' => isset($options['name'])
        ? $options['name'] : '',
  );
  $form['cron_limit'] = array(
    '#type' => 'textfield',
    '#title' => t('Cron limit'),
    '#description' => t('The maximum number of resources indexed for this ' .
        'context in each pass of a <a href="@cron">cron maintenance task</a>.' .
        ' If necessary, reduce the number of items to prevent timeouts and ' .
        'memory errors while indexing.',
        array('@cron' => url('admin/reports/status'))),
    '#default_value' => isset($options['cron_limit'])
        ? $options['cron_limit'] : 50,
  );
  $schemas = array();
  foreach (apachesolr_rdf_schemas() as $id => $data) {
    $schemas[$id] = $data['name'];
  }
  // TODO: Use JS or AHA to display description of selected schema
  $form['schema'] = array(
    '#type' => 'select',
    '#title' => t('Schema'),
    '#description' => t('The schema used by the Solr server and, hence, the ' .
        'method that should be used for indexing and searching.'),
    '#options' => $schemas,
    '#default_value' => isset($options['schema'])
        ? $options['schema'] : NULL,
  );
  // TODO: Do we really need this? And is this the best way to provide it?
  $form['schema_arguments'] = array(
    '#type' => 'textarea',
    '#title' => t('Schema arguments'),
    '#description' => t('This field is used for additional arguments that ' .
        'should be available to the schema-specific methods. The concrete ' .
        "handling and format of this field depends on the schema used."),
    '#default_value' => isset($options['schema_arguments'])
        ? $options['schema_arguments'] : '',
  );
  // IDEA: additional filters that are added to all queries
  $form['solr_host'] = array(
    '#type' => 'textfield',
    '#title' => t('Solr host name'),
    '#description' => t('Host name of your Solr server, e.g. ' .
        '<code>localhost</code> or <code>example.com</code>.'),
    '#default_value' => isset($options['solr_host'])
        ? $options['solr_host']
        : variable_get('apachesolr_host', 'localhost'),
  );
  $form['solr_port'] = array(
    '#type' => 'textfield',
    '#title' => t('Solr port'),
    '#description' => t('Port on which the Solr server listens. The Jetty ' .
        'example server is 8983, while Tomcat is 8080 by default.'),
    '#default_value' => isset($options['solr_port'])
        ? $options['solr_port']
        : variable_get('apachesolr_port', '8983'),
  );
  $form['solr_path'] = array(
    '#type' => 'textfield',
    '#title' => t('Solr path'),
    '#description' => t('Path that identifies the Solr request handler to be ' .
        'used.'),
    '#default_value' => isset($options['solr_path'])
        ? $options['solr_path']
        : variable_get('apachesolr_path', '/solr'),
  );
  $form['context'] = array(
    '#type' => 'value',
    '#value' => $context,
  );
  $form['submit'] = array('#type' => 'submit', '#value' => t('Save'));

  return $form;
}

/**
 * Validation function for apachesolr_rdf_edit_context_form.
 */
function apachesolr_rdf_edit_context_form_validate($form, &$form_state) {
  $values = $form_state['values'];
  // If the context isn't enabled, we don't care about what nonsense there might
  // be in the other form fields.
  if (!$values['enabled']) {
    return;
  }

  $value = $values['id'];
  if (empty($value)) {
    form_set_error('id',
        t('You must specify an ID when enabling a context.'));
  }
  $value = $values['name'];
  if (empty($value)) {
    form_set_error('name',
        t('You must specify a name when enabling a context.'));
  }
  $value = $values['cron_limit'];
  if (!preg_match('/[0-9]+/', $value)) {
    form_set_error('cron_limit',
        t('The cron limit has to be a non-negative integer.'));
  }
  $value = $values['solr_host'];
  if (empty($value)) {
    form_set_error('solr_host',
        t('You must specify the Solr host name when enabling a context.'));
  }
  $value = $values['solr_port'];
  if (!preg_match('/[1-9][0-9]*/', $value)) {
    form_set_error('solr_port',
        t('The port has to be a positive integer.'));
  }
  $value = $values['solr_path'];
  if (empty($value)) {
    form_set_error('solr_path',
        t('You must specify the Solr path when enabling a context.'));
  }
}

/**
 * Submit function for apachesolr_rdf_edit_context_form.
 */
function apachesolr_rdf_edit_context_form_submit($form, &$form_state) {
  $values = $form_state['values'];
  $context = $values['context'];

  $contexts = variable_get('apachesolr_rdf_contexts', array());
  $prev_enabled = $contexts[$context]['enabled'];
  $values['id'] = urlencode($values['id']);
  unset($values['submit']);
  $contexts[$context] = $values;
  variable_set('apachesolr_rdf_contexts', $contexts);
  apachesolr_rdf_enabled_contexts(TRUE);

  if ($contexts[$context]['enabled'] != $prev_enabled) {
    // If the enabled state changed, the menu has to be rebuilt
    menu_rebuild();
    if (!$prev_enabled) {
      // If the state changed to enabled, the context db has to be updated
      apachesolr_rdf_update_context($context);
    }
  }

  drupal_set_message(t('The settings for the context @context were ' .
      'successfully changed.', array('@context' => $context)), 'status');
}
