<?php
// $Id: apachesolr_rdf.pages.inc,v 1.1.2.3 2009/07/24 23:47:19 drunkenmonkey Exp $

/**
 * Outputs an overview page for all enabled Apachesolr RDF searches.
 */
function apachesolr_rdf_search_overview() {
  $contexts = apachesolr_rdf_enabled_contexts();
  if (empty($contexts)) {
    $output = '<p>' . t('There are no RDF searches available.') . '</p>';
    if (user_access('administer site configuration')) {
      $output .= "\n</p>" . t('You can enable some at the <a href="@url">' .
          'Apache Solr settings page</a>.',
          array('@url' => url('admin/settings/apachesolr_rdf'))) . '</p>';
    }
    return $output;
  }
  $output = '<p>' . t('The following RDF searches are available:') . "</p>\n";
  $items = array();
  $ids = array();
  foreach ($contexts as $options) {
    if (!isset($ids[$options['id']])) {
      $items[] = l($options['name'], "search/apachesolr_rdf/{$options['id']}");
      $ids[$options['id']] = TRUE;
    }
  }
  $output .= theme('item_list', $items);
  return $output;
}

/**
 * Displays a search and/or search results appropriate for the selected
 * schema.
 */
function apachesolr_rdf_show_search($schema, $id) {
  $output = '';
  foreach (apachesolr_rdf_enabled_contexts() as $options) {
    if ($options['id'] == $id) {
      $output = "<h3>{$options['name']}</h3>";
      break;
    }
  }
  if (!$output) {
    watchdog('Apache Solr RDF', 'The RDF context with the id "@id" is either ' .
        'unknown or disabled.', array('@id' => $id), WATCHDOG_ERROR);
    return apachesolr_rdf_search_overview();
  }

  $keys = apachesolr_rdf_search_keys($id);
  $filters = isset($_GET['filters']) ? $_GET['filters'] : array();
  $sort = isset($_GET['sort']) ? $_GET['sort'] : '';
  $page = isset($_GET['page']) ? $_GET['page'] : 0;
  $output .= drupal_get_form('search_form', '', $keys, "apachesolr_rdf/$id");

  if ($keys) {
    $execute_search = apachesolr_rdf_get_schema_function($schema,
        'execute_search');
    if (!$execute_search) {
      return FALSE; // TODO Anything more useful to do here?
    }

    watchdog('search', "$keys (apachesolr_rdf/$id)", NULL);
    $output .= $execute_search($options, $keys, $filters, $sort, $page);
  }

  return $output;
}

/**
 * Submit function for an Apachesolr RDF search.
 */
function apachesolr_rdf_search_submit($form, &$form_state) {
  $form_state['redirect'] = 'search/apachesolr_rdf/' .
      $form_state['values']['apachesolr_rdf_id'] . '/' .
      $form_state['values']['keys'];
}

//
// Schema functions
//
// - dynamic fields
//

/**
 * Alters the search form by adding advanced RDF search options and telling the
 * form to use the right submit function.
 */
function apachesolr_rdf_search_form_alter_dynamic(
    &$form, &$form_state, $id) {
  /*$advanced = array(
    '#type' => 'fieldset',
    '#title' => t('Advanced Search'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  // TODO Add property->value fields (+ AHAH "More" button)
  $advanced[''] = array(
  );
  $form['advanced'] = $advanced;*/
}

/**
 * Executes a search using the "dynamic fields" schema.
 */
function apachesolr_rdf_execute_search_dynamic($options, $keys, $filters, $sort,
    $page) {
  // Get solr object
  $solr = apachesolr_get_solr($options['solr_host'], $options['solr_port'],
      $options['solr_path']);

  // Build filter string
  $filterarr = array();
  foreach ($filters as $field => $values) {
    $values = array_map(array($solr, 'escape'), $values);
    // FIXME This is just wrong. Need to figure out if "{$field}_s" or "~_t".
    $filterarr[] = $solr->escape($field) . ':(' . implode(' ', $values) . ')';
  }
  $filterstring = implode(' ', $filterarr);

  // Get query object
  list($module, $class) = variable_get('apachesolr_query_class',
      array('apachesolr', 'Solr_Base_Query'));
  include_once drupal_get_path('module', $module) .'/'. $class .'.php';

  try {
    $query = new $class($solr, $keys, $filterstring,
        $sort, "search/apachesolr_rdf/{$options['id']}");
  }
  catch (Exception $e) {
    watchdog('Apache Solr RDF', nl2br(check_plain($e->getMessage())), NULL,
        WATCHDOG_ERROR);
    return;
  }

  // Set parameters
  $params = array(
    'fl' => 'uri,context,' .
        APACHESOLR_RDF_TYPE . '_s,' .
        APACHESOLR_RDF_LABEL . '_t,' .
        APACHESOLR_RDF_COMMENT . '_t,',
    'rows' => variable_get('apachesolr_rows', 10),
    'facet' => 'true',
    'facet.mincount' => 1,
    'facet.sort' => 'true'
  );
  $params['start'] = $page * $params['rows'];

  // Search and render results
  $response = $solr->search($query->get_query_basic(), $params['start'],
      $params['rows'], $params);
  return apachesolr_rdf_render_response_dynamic
      ($options['id'], $response, $query, $params);
}

/**
 * Renders a search response of the "dynamic fields" schema.
 */
function apachesolr_rdf_render_response_dynamic
    ($id, $response, $query, $params) {
  // Pager query to get a pager output
  $total = $response->response->numFound;
  if (!$total) {
    return theme('box', t('Your search yielded no results'),
        search_help('search#noresults', drupal_help_arg()));
  }
  pager_query("SELECT %d", $params['rows'], 0, NULL, $total);

  $results = array();
  $type_f = APACHESOLR_RDF_TYPE . '_s';
  $label_f = APACHESOLR_RDF_LABEL . '_t';
  $comment_f = APACHESOLR_RDF_COMMENT . '_t';

  foreach ($response->response->docs as $doc) {
    $results[] = array(
      'link' => $doc->uri,
      'type' => isset($doc->$type_f) ? $doc->$type_f : FALSE,
      'title' => isset($doc->$label_f) ? $doc->$label_f : $doc->uri,
      'snippet' => isset($doc->$comment_f) ? $doc->$comment_f : FALSE,
    );
  }

  return theme('box', t('Search results'), theme('search_results', $results,
      "apachesolr_rdf/$id"));
}

//
// - property_object
//

/**
 * Alters the search form by adding advanced RDF search options and telling the
 * form to use the right submit function.
 */
function apachesolr_rdf_search_form_alter_text_data(
    &$form, &$form_state, $id) {
  /*$advanced = array(
    '#type' => 'fieldset',
    '#title' => t('Advanced Search'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  // TODO Add property->value fields (+ AHAH "More" button)
  $advanced[''] = array(
  );
  $form['advanced'] = $advanced;*/
}

/**
 * Executes a search using the "text data" schema.
 */
function apachesolr_rdf_execute_search_text_data($options, $keys, $filters, $sort,
    $page) {
  // Get solr object
  $solr = apachesolr_get_solr($options['solr_host'], $options['solr_port'],
      $options['solr_path']);

  // Build filter string
  $filterarr = array();
  foreach ($filters as $field => $values) {
    foreach ($values as $value) {
      $filterarr[] = '"' . $solr->escape("$field $value") . '"';
    }
  }
  $filterstring = implode(' ', $filterarr);

  // Get query object
  list($module, $class) = variable_get('apachesolr_query_class',
      array('apachesolr', 'Solr_Base_Query'));
  include_once drupal_get_path('module', $module) .'/'. $class .'.php';

  try {
    $query = new $class($solr, $keys, $filterstring,
        $sort, "search/apachesolr_rdf/{$options['id']}");
  }
  catch (Exception $e) {
    watchdog('Apache Solr RDF', nl2br(check_plain($e->getMessage())), NULL,
        WATCHDOG_ERROR);
    return;
  }

  // Set parameters
  $params = array(
    'fl' => 'uri,context,type,property,text',
    'rows' => variable_get('apachesolr_rows', 10),
    'facet' => 'true',
    'facet.mincount' => 1,
    'facet.sort' => 'true'
  );
  $params['start'] = $page * $params['rows'];

  // Search and render results
  $response = $solr->search($query->get_query_basic(), $params['start'],
      $params['rows'], $params);
  return apachesolr_rdf_render_response_text_data
      ($options['id'], $response, $query, $params);
}

/**
 * Renders a search response of the "text data" schema.
 */
function apachesolr_rdf_render_response_text_data
    ($id, $response, $query, $params) {
  // Pager query to get a pager output
  $total = $response->response->numFound;
  if (!$total) {
    return theme('box', t('Your search yielded no results'),
        search_help('search#noresults', drupal_help_arg()));
  }
  pager_query("SELECT %d", $params['rows'], 0, NULL, $total);

  $results = array();
  foreach ($response->response->docs as $doc) {
    $type = is_array($doc->type) ? implode(', ', $doc->type) : $doc->type;
    $label = $comment = FALSE;
    $prop_count = count($doc->property);
    for ($i = 0; $i < $prop_count; ++$i) {
      if ($doc->property[$i] == APACHESOLR_RDF_LABEL) {
        $label = $doc->text[$i];
      }
      else if ($doc->property[$i] == APACHESOLR_RDF_COMMENT) {
        $comment = $doc->text[$i];
      }
      // When we've found all desired fields, stop looking.
      if ($label && $comment) {
        break;
      }
    }
    $results[] = array(
      'link' => $doc->uri,
      'type' => isset($type) ? $type : FALSE,
      'title' => isset($label) ? $label : $doc->uri,
      'snippet' => isset($comment) ? $comment : FALSE,
    );
  }

  return theme('box', t('Search results'), theme('search_results', $results,
      "apachesolr_rdf/$id"));
}
