/**
 * @project siren
 * @author Renaud Delbru [ 4 Feb 2009 ]
 * @link http://renaud.delbru.fr/
 * @copyright Copyright (C) 2007, All rights reserved.
 */
package org.sindice.lucene.index.benchmark.btc;

import java.io.IOException;

import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.sindice.solr.plugins.analysis.CustomStandardTokenizer;

public class URITrailingSlashFilter extends TokenFilter {

  public URITrailingSlashFilter(final TokenStream in) {
    super(in);
  }

  @Override
  public final Token next(Token reusableToken) throws IOException {
    assert reusableToken != null;
    if ((reusableToken = input.next(reusableToken)) == null) return null;

    if (reusableToken.type().equals(CustomStandardTokenizer.getTokenType(CustomStandardTokenizer.URI))) {
      final char[] buffer = reusableToken.termBuffer();
      final int length = reusableToken.termLength();

      // Remove trailing slash
      if (buffer[length-1] == '/')
        // Strip last 2 characters off
        reusableToken.setTermLength(length - 1);
    }
    return reusableToken;
  }

}
