package org.sindice.lucene.index.benchmark.btc;

import java.util.HashMap;
import java.util.Map;

import org.apache.lucene.analysis.TokenStream;
import org.apache.solr.analysis.TokenFilterFactory;

public class URITrailingSlashFilterFactory implements TokenFilterFactory {
    
    private Map<String, String> args;

    @Override
    public TokenStream create(TokenStream tokens) {
        return new URITrailingSlashFilter(tokens);
    }

    @Override
    public Map<String, String> getArgs() {
        return this.args;
    }

    @Override
    public void init(Map<String, String> args) {
        // Arguments are ignored
        this.args = new HashMap<String, String>(args);
    }

}
