#!/bin/bash

# IMPORTANT:
# `ddev` is required: https://ddev.readthedocs.io/en/stable/

# Base folders.
mkdir d10api
cd d10api

# Launch D10 site with drush and the api module brought via composer.
ddev config --project-type=drupal10 --docroot=web --create-docroot
ddev start
ddev composer create drupal/recommended-project
ddev composer require drush/drush
ddev composer require 'drupal/api:2.x-dev@dev'
ddev drush site:install --account-name=admin --account-pass=admin -y

# Enable api module and any others you might need.
ddev drush -y en api

# Bring some projects and parse them.
ddev drush api:quick-wizard https://git.drupalcode.org/project/examples.git
ddev drush cron
ddev drush queue:run api_parse_queue

ddev drush api:quick-wizard https://git.drupalcode.org/project/config_notify.git
ddev drush cron
ddev drush queue:run api_parse_queue

ddev drush api:quick-wizard https://git.drupalcode.org/project/project_browser.git
ddev drush cron
ddev drush queue:run api_parse_queue

ddev drush -y role:perm:add anonymous 'access API reference'
ddev drush cr

# Front-end page.
ddev launch api/projects

# Admin page.
ddev drush user:login admin/config/development/api

# Remove all the things.
# ddev stop && ddev delete --omit-snapshot
# cd .. && rm -rf d10api