<?php

/**
 * @file
 * Describe hooks provided by the API Browser module.
 */

/**
 * Alter the project info before the project is created.
 *
 * @param array $projectInfo
 *   Project info used to create the Project.
 * @param array $results
 *   Data returned from the project endpoint.
 */
function hook_api_browser_project_info_data_alter(array &$projectInfo, array $results) {

}

/**
 * Alter the project info before the project is created.
 *
 * @param array $projectInfo
 *   Project info used to create the Project.
 * @param array $results
 *   Data returned from the project endpoint.
 */
function hook_api_browser_project_info_data_ENTITY_ID_alter(array &$projectInfo, array $results) {

}

/**
 * Alter the Guzzle request before it is sent.
 *
 * @param array $options
 *   List of Guzzle Options.
 * @param string $endpoint
 *   Endpoint for Project list.
 */
function hook_api_browser_project_list_request_alter(array &$options, string &$endpoint) {

}

/**
 * Alter the Guzzle request before it is sent.
 *
 * @param array $options
 *   List of Guzzle Options.
 * @param string $endpoint
 *   Endpoint for Project list.
 */
function hook_api_browser_project_list_request_ENTITY_ID_alter(array &$options, string &$endpoint) {

}

/**
 * Alter items from project request after they have been queried with JSON Path.
 *
 * @param array $items
 *   Items to loop through.
 */
function hook_api_browser_project_list_alter(array &$items) {

}

/**
 * Alter items from project request after they have been queried with JSON Path.
 *
 * @param array $items
 *   Items to loop through.
 */
function hook_api_browser_project_list_ENTITY_ID_alter(array &$items) {

}

/**
 * Alter Guzzle options before the request for project info.
 *
 * @param array $options
 *   Options being provided to Guzzle request.
 * @param string $endpoint
 *   Endpoint to send the request to.
 * @param array $list_item
 *   Item from the project list request.
 */
function hook_api_browser_project_request_alter(array &$options, string &$endpoint, array $list_item) {
  $options['headers']['Content-Type'] = 'application/json';
}

/**
 * Alter Guzzle options before the request for project info.
 *
 * @param array $options
 *   Options being provided to Guzzle request.
 * @param string $endpoint
 *   Endpoint to send the request to.
 * @param array $list_item
 *   Item from the project list request.
 */
function hook_api_browser_project_request_ENTITY_ID_alter(array &$options, string &$endpoint, array $list_item) {
  $options['headers']['Content-Type'] = 'application/json';
}

/**
 * Alter the Project after it was created but before it is returned in the list.
 *
 * @param \Drupal\project_browser\ProjectBrowser\Project $project
 *   Project that can be altered.
 * @param array $data
 *   Data returned from project info.
 */
function hook_api_browser_project_browser_project_alter(\Drupal\project_browser\ProjectBrowser\Project &$project, array $data) {
  $project->machineName = 'example_project';
}

/**
 * Alter the Project after it was created but before it is returned in the list.
 *
 * @param \Drupal\project_browser\ProjectBrowser\Project $project
 *   Project that can be altered.
 * @param array $data
 *   Data returned from project info.
 */
function hook_api_browser_project_browser_project_ENTITY_ID_alter(\Drupal\project_browser\ProjectBrowser\Project &$project, array $data) {
  $project->machineName = 'example_project';
}

/**
 * Alter the list of Authentication types.
 *
 * @param array $list
 *   Return a list of authentication types used.
 */
function hook_api_browser_auth_types_alter(array &$list) {
  $list['foo'] = t('Bar');
}

/**
 * Provide authentication items used for the request.
 *
 * @param array $config_screen
 *   Config screen that should provide fields.
 * @param string $auth_type
 *   Authentication type selected.
 * @param array $credentials
 *   Credentials for the provided authentication type.
 */
function hook_api_browser_auth_config_screen_alter(array &$config_screen, string $auth_type, array $credentials) {
  if ($auth_type === 'foo') {
    $config_screen['example'] = [
      '#type' => 'textfield',
      '#title' => t('Example Field'),
      '#description' => t('Provide info used for authentication.'),
      '#required' => TRUE,
      '#default_value' => $credentials['example'] ?? '',
    ];
  }
}
