# Project Browser API Browser

The Project Browser API Browser module provides a way to create Project Browsers
that connect with external APIs to provide the content source. This allows
organizations to create curated lists of projects for content administrators to
browse and install.

## Features

The Project Browser API Browser creates a configuration entity named *Service*.

The Service is the endpoint you are connecting to. 

For example, Packagist:

`api_browser.service.packagist_modules.yml`

```
langcode: en
status: true
id: packagist_modules
name: 'Packagist Drupal Modules'
description: 'Lists all public Drupal Modules from packagist.org'
categories: |-
  example_1|Example 1
  example_2|Example 2
listing:
  endpoint: 'https://packagist.org/packages/list.json'
  method: GET
  auth: no_auth
  path: packages
  pagination: false
  page: ''
  per_page: ''
search:
  -
    parameter: type
    value: drupal-module
  -
    parameter: 'fields[]'
    value: type
  -
    parameter: 'fields[]'
    value: repository
  -
    parameter: 'fields[]'
    value: abandoned
project:
  enable: true
  endpoint: 'https://packagist.org/packages/{{item_key}}.json'
  method: GET
  auth: no_auth
  path: package
field_mapping:
  type: '{{ type | replace({"drupal-":""}) }}'
  package_name: '{{ name }}'
  machine_name: '{{ name }}'
  url: '{{ repository }}'
  logo: "{{ url('<front>') }}core/misc/logo/drupal-logo.svg"
  title: '{{ name | split("/")[1] }}'
  short_description: '{{ description }}'
  long_description: '{{ description }}'
  compatible: '{{ TRUE }}'
  maintained: '{{ abandoned != TRUE }}'
  covered: '{{ FALSE }}'
  active: '{{ abandoned != TRUE }}'
  star_user_count: '{{ github_stars }}'
  project_usage_total: '{{ downloads.total }}'
  created: '{{ (packages | first).time }}'
  changed: '{{ (packages | last).time }}'
  author: "{{ (maintainers| column('name')) | join(', ') }}"
  categories: ''
  images: ''
  warnings: ''

```

Twig is used for being able to parse and manipulate the data returned from the
API endpoint to return the needed values for each of the browser requirements.

A derivative is used in the module's code to dynamically generate Project
Browser Services from these new config entities.

## Post-Installation

Change "Project Browser API Settings" to "API Browser Settings"
Click Add Service


After you install this module, visit the Project Browser API Browser Settings
page in your Drupal admin. 

In the Admin menu visit:
Configuration > Development > Project Browser
Click on API Browser Settings

From there, you can see the services that have already been installed.

After you are content with those, visit the Project Browser's configuration page
and select the Project Browser Service you want to make available. Save and view
your changes in the Project Browser.

## Additional Requirements

There is a known issue [#3457003] in Project Browser at the moment and is
necessary for the required patch.

This module requires Project Browser which is currently in contrib. Once Project
Browser is merged into core, there should be no changes.

## Recommended modules/libraries

None at this time.

## Similar projects

* [Project Browser Source Example](https://git.drupalcode.org/project/project_browser/-/tree/2.0.x/modules/project_browser_source_example?ref_type=heads)
  * A Submodule of Project Browser that provides an example browser.
* [Project Browser Drupal Packagist(https://www.drupal.org/project/pb_drupal_packagist)]
  * Use packages.drupal.org as the source of information to bring Drupal modules
    into Project Browser. Helped us understand the power to extending Project
    Browser!
* [Project Browser Gitlab](https://www.drupal.org/project/project_browser_gitlab)
  * Integrates Project Browser with Gitlab in order to browse (and install in
    the future) projects from a Gitlab instance.
