<?php

namespace Drupal\api_browser\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Creates a derivative of the ApiBrowserProjectBrowser Project Browser Source.
 */
class ApiBrowserProjectBrowser extends DeriverBase implements ContainerDeriverInterface {

  /**
   * Creates a new ApiBrowserProjectBrowser object.
   */
  public function __construct(protected string $base_plugin_id, protected EntityTypeManagerInterface $entityTypeManager) {

  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    // @phpstan-ignore-next-line
    return new static(
      $base_plugin_id,
      $container->get('entity_type.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition): array {
    $sources = $this->entityTypeManager->getStorage('api_browser_service')->loadMultiple();
    foreach ($sources as $source) {
      $this->derivatives[$source->id()] = $base_plugin_definition;
      $this->derivatives[$source->id()]['label'] = $source->label();
      $this->derivatives[$source->id()]['service'] = $source;
    }

    return $this->derivatives;
  }

}
