<?php

namespace Drupal\api_connection;

use Drupal\api_connection\Event\ApiConnectionEnvironmentEvent;
use Drupal\api_connection\Event\ApiConnectionEvents;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * Provides logic for defining the available environments.
 */
class ApiConnectionEnvironment implements ApiConnectionEnvironmentInterface {

  /**
   * The event dispatcher service.
   *
   * @var \Symfony\Component\EventDispatcher\EventDispatcherInterface
   */
  protected $eventDispatcher;

  /**
   * Environments constructor.
   *
   * @param \Symfony\Component\EventDispatcher\EventDispatcherInterface $event_dispatcher
   *   The event dispatcher service.
   */
  public function __construct(EventDispatcherInterface $event_dispatcher) {
    $this->eventDispatcher = $event_dispatcher;
  }

  /**
   * Get the available environments.
   *
   * @return array
   *   List of available environments.
   */
  public function getEnvironments() {
    $environments = [
      'dev' => t('Development'),
      'test' => t('Testing / staging'),
      'live' => t('Live / production'),
    ];
    $event = new ApiConnectionEnvironmentEvent($environments);
    $this->eventDispatcher->dispatch(ApiConnectionEvents::ENVIRONMENT, $event);
    return $event->getEnvironments();
  }

}
