<?php

namespace Drupal\api_connection\Plugin;

/**
 * Defines an interface for REST API connection plugins.
 */
interface RestApiConnectionInterface extends ApiConnectionInterface {

  /**
   * Send request to the REST API.
   *
   * @param string $endpoint
   *   The endpoint on the API.
   * @param string $method
   *   The request method.
   * @param array $options
   *   Options for the request i.e body, header, ...
   *
   * @return bool|array
   *   Return response object.
   *
   * @throws \Drupal\api_connection\RestApiEnvironmentUrlException
   */
  public function sendRequest($endpoint, $method, array $options = []);

}
