<?php

namespace Drupal\api_data_connector\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'api_data_connector_widget_tags' widget.
 */
#[FieldWidget(
  id: 'api_data_connector_widget_tags',
  label: new TranslatableMarkup('API Data Connector Widget (Tags style)'),
  field_types: [
    'api_data_connector_item',
  ],
  multiple_values: TRUE,
)]
class APIDataConnectorTagsWidget extends APIDataConnectorWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    // Call the parent method to get the base element.
    $element = parent::formElement($items, $delta, $element, $form, $form_state);

    // Ensure that the target_id element exists.
    if (isset($element['target_id'])) {
      $element['target_id']['#tags'] = TRUE;
      // Step 1: Extract target_id values
      $target_names = array_column($items->getValue(), 'target_name');
      // Step 2: Convert to a comma-separated string
      $target_names_string = implode(', ', $target_names);
      // Set the default value to the referenced entities.
      $element['target_id']['#default_value'] = $target_names_string ? $target_names_string . ',' : NULL;
    }
    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    preg_match_all('/\((\d+)\)/', $values['target_id'], $ids);
    // Step 2: Build the desired array structure
    $elements = explode(',', rtrim($values['target_id'], ', '));
    $target_names = array_map('trim', $elements);
    $result = [
      'target_id' => [],
    ];
    foreach ($ids[1] as $key => $id) {
      $result['target_id'][] = [
        'target_id' => trim($id),
        'target_name' => $target_names[$key],
      ];
    }
    return $result['target_id'];
  }

}
