<?php

namespace Drupal\api_data_connector\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'api_data_connector_formatter' formatter.
 */
#[FieldFormatter(
  id: 'api_data_connector_formatter',
  label: new TranslatableMarkup('API Data Connector Formatter.'),
  field_types: [
    'api_data_connector_item',
  ],
)]
class ApiDataConnectorFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];
    foreach ($items as $delta => $item) {
      $entity = $item->target_name;
      if ($entity) {
        $elements[$delta] = [
          '#markup' => $entity,
        ];
      }
    }
    return $elements;
  }

}
