<?php

namespace Drupal\api_data_connector\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\WidgetBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'api_data_connector_widget' widget.
 */
#[FieldWidget(
  id: 'api_data_connector_widget',
  label: new TranslatableMarkup('API Data Connector Widget'),
  field_types: [
    'api_data_connector_item',
  ],
)]
class APIDataConnectorWidget extends WidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    // Create the entity autocomplete field.
    $element['target_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t($element['#title']),
      '#rows' => $this->getFieldSetting('api_url'),
      '#autocomplete_route_name' => 'api_data_connector.autocomplete',
      '#autocomplete_route_parameters' => [
        'api_url' => ($this->getFieldSetting('api_fieldset') != NULL) ? $this->getFieldSetting('api_fieldset')['api_url'] : '',
        'query' => ($this->getFieldSetting('api_fieldset') != NULL) ? $this->getFieldSetting('api_fieldset')['query_parameter'] : '',
        'key' => ($this->getFieldSetting('mapping_fieldset') != NULL) ? $this->getFieldSetting('mapping_fieldset')['key'] : '',
        'value' => ($this->getFieldSetting('mapping_fieldset') != NULL) ? $this->getFieldSetting('mapping_fieldset')['value'] : '',
      ],
      '#default_value' => !empty($items[$delta]->target_name) ? $items[$delta]->target_name : NULL,
      '#description' => $this->t('Start typing to select entities.'),
    ];

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    foreach ($values as $key => $value) {
      // The entity_autocomplete form element returns an array when an entity
      // was "autocreated", so we need to move it up a level.
      preg_match_all('/\((\d+)\)/', $value['target_id'], $ids);
      // Step 2: Build the desired array structure
      $elements = explode(',', rtrim($value['target_id'], ', '));
      $target_names = array_map('trim', $elements);
      unset($values[$key]['target_id']);
      foreach ($ids[1] as $keyid => $id) {
        $values['target_id'][$key] = [
          'target_id' => trim($id),
          'target_name' => $target_names[$keyid],
        ];
      }
    }
    return $values['target_id'];
  }

}
