<?php

namespace Drupal\api_data_connector\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\Plugin\Field\FieldWidget\OptionsWidgetBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Plugin implementation of the 'api_data_connector_select' widget.
 */
#[FieldWidget(
  id: 'api_data_connector_select',
  label: new TranslatableMarkup('Api Data Connector Options Select'),
  field_types: [
    'api_data_connector_item',
  ],
  multiple_values: TRUE,
)]
class ApiDataConnectorOptionsSelectWidget extends OptionsWidgetBase {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element = parent::formElement($items, $delta, $element, $form, $form_state);

    $element += [
      '#type' => 'select',
      '#options' => [
        '22' => $this->t('Option 1'),
        '12' => $this->t('Option 2'),
        '23' => $this->t('Option 3'),
      ],
      '#default_value' => isset($items[0]['value']) ? $items[0]['value'] : '',
      '#multiple' => $this->multiple,
      // Do not display a 'multiple' select box if there is only one option.
    ];

    return $element;
  }

}
