<?php

namespace Drupal\api_proxy\Plugin;

use Drupal\Core\Cache\CacheableResponse;
use Drupal\Core\Form\SubformStateInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

interface HttpApiInterface {

  public function getBaseUrl(): string;
  public function shouldForwardHeaders(): bool;
  public function getAdditionalHeaders(): array;
  public function isCacheForced(): int;
  public function getForcedCacheTtl(): int;
  public function changeInputToDrupal(Request $request): Request;
  public function changeOutputFromApi(Response $response): Response;
  public function forward(Request $request, string $uri): Response;
  public function corsResponse(Request $request): CacheableResponse;

  /**
   * Adds additional form elements to the configuration form.
   *
   * @param array $form
   *   The configuration form to alter for the this plugin settings.
   * @param \Drupal\Core\Form\SubformStateInterface $form_state
   *   The form state for the plugin settings.
   *
   * @return array
   *   The form with additional elements.
   */
  public function addMoreConfigurationFormElements(array $form, SubformStateInterface $form_state): array;

}
