<?php

namespace Drupal\api_response_check\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides the latest API response from the database.
 *
 * @internal
 */
class ApiResponseForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'api_response_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form['#markup'] = t('Click the below button to get the latest API Response results');

    $form['actions']['#type'] = 'actions';
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Get Instant Response'),
      '#button_type' => 'primary',
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Get API URLs from the configuration.
    if ($config_data = \Drupal::config('api_response_check.adminsettings')->get('api_inputs')) {
      $urls = explode(PHP_EOL, $config_data);
      // Log the information into Database.
      foreach ($urls as $uri) {
        $api_url = trim($uri);
        $response = \Drupal::httpClient()->get($api_url, ['http_errors' => FALSE, 'headers' => ['Accept' => 'text/plain']]);
        if ($response->getStatusCode() == 200) {
          $database = \Drupal::database()->insert('api_response_check')
            ->fields([
              'status' => 'Success',
              'api_url' => $api_url,
              'timestamp' => time(),
              'severity' => 1,
            ])
            ->execute();
        }
        else {
          $database = \Drupal::database()->insert('api_response_check')
            ->fields([
              'status' => 'Failure',
              'api_url' => $api_url,
              'timestamp' => time(),
              'severity' => 0,
            ])
            ->execute();
        }
      }
    }
  }

}
