<?php

namespace Drupal\api_sirene_open_data_france\Controller;

use Drupal\Core\Controller\ControllerBase;

use Drupal\Component\Serialization\JSON;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Drupal\api_sirene_open_data_france\EntrepriseDataApiManager;

class EntrepriseAjaxController extends ControllerBase {
  
  //function for autocomplete
  public function entreprise_data_autocomplete(Request $request){
    $return = []; //our variable to fill with data to return to autocomplete result
    
    $search = "sirene";
    $search_string = \Drupal::request()->request->get('siret_sirene');
    if(strlen($search_string) > 9) $search = "siret";
    
    if($search_string == "") {
      $search_string = \Drupal::request()->request->get('query_name');
      $search = "full_text";
    }
    //$type = "housenumber"; // can be housenumber, street, locality or municipality.

    $edataApi = new EntrepriseDataApiManager();
    switch($search){
      case 'sirene':
        $return = $edataApi->searchBySirene($search_string);
        break;
      case 'siret':
        $return = $edataApi->searchBySiret($search_string);
        break;
      case 'full_text':
        $return = $edataApi->searchByName($search_string);
        $return = $return['etablissement'];
        break;
    }

    return new JsonResponse(json_encode($return), 200, [], true);
  }
  
}