<?php

namespace Drupal\api_toolkit\Validation;

use Drupal\Core\DependencyInjection\ClassResolverInterface;
use Drupal\Core\Validation\ConstraintValidatorFactory;
use Symfony\Component\Validator\Validation;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Factory for creating validators.
 */
class ValidatorFactory {

  /**
   * The class resolver.
   *
   * @var \Drupal\Core\DependencyInjection\ClassResolverInterface
   */
  protected $classResolver;

  /**
   * Constructs a new ValidatorFactory.
   *
   * @param \Drupal\Core\DependencyInjection\ClassResolverInterface $class_resolver
   *   A class resolver.
   */
  public function __construct(ClassResolverInterface $class_resolver) {
    $this->classResolver = $class_resolver;
  }

  /**
   * Creates a validator.
   */
  public function createValidator(): ValidatorInterface {
    return Validation::createValidatorBuilder()
      ->enableAnnotationMapping()
      ->setConstraintValidatorFactory(new ConstraintValidatorFactory($this->classResolver))
      ->getValidator();
  }

}
