<?php

namespace Drupal\api_toolkit\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates whether an entity with a certain UUID exists.
 *
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @Constraint(
 *     id = "entity_exists",
 *     label = @Translation("Checks if an entity with a certain id exists", context = "Validation"),
 * )
 */
class EntityExists extends Constraint {

  /**
   * The error message in case of an invalid entity type.
   *
   * @var string
   */
  public string $invalidEntityType = 'An entity type with ID %value does not exist.';

  /**
   * The error message in case of a non-existing entity UUID.
   *
   * @var string
   */
  public string $invalidId = 'No @entityType with ID %value exists.';

  /**
   * The entity type ID.
   *
   * @var string|null
   */
  public ?string $entityTypeId = NULL;

  /**
   * The entity bundle.
   *
   * @var string|null
   */
  public ?string $bundle = NULL;

  /**
   * The field name to check.
   *
   * @var string
   */
  public string $fieldName = 'uuid';

  /**
   * {@inheritdoc}
   */
  public function getRequiredOptions(): array {
    return ['entityTypeId'];
  }

}
