<?php

namespace Drupal\api_toolkit\ArgumentResolver;

use Drupal\api_toolkit\Request\ApiRequestInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Controller\ArgumentValueResolverInterface;
use Symfony\Component\HttpKernel\ControllerMetadata\ArgumentMetadata;

/**
 * Converts normal Synfomy requests to ApiRequestInterface instances.
 */
class ApiRequestResolver implements ArgumentValueResolverInterface {

  /**
   * {@inheritdoc}
   */
  public function supports(Request $request, ArgumentMetadata $argument) {
    return is_a($argument->getType(), ApiRequestInterface::class, TRUE);
  }

  /**
   * {@inheritdoc}
   */
  public function resolve(Request $request, ArgumentMetadata $argument) {
    $requestClass = $argument->getType();
    yield $requestClass::fromRequest($request);
  }

}
