<?php

namespace Drupal\api_toolkit\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Validates whether a certain source ID exists in the mapping of a migration.
 *
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @Constraint(
 *     id = "migration_source_exists",
 *     label = @Translation("Migration source exists", context = "Validation"),
 * )
 */
class MigrationSourceExists extends Constraint {

  /**
   * The error message.
   *
   * @var string
   */
  public string $invalidId = 'No source with ID %value exists in migration %migration.';

  /**
   * The migration id.
   *
   * @var string|null
   */
  public ?string $migration = NULL;

  /**
   * {@inheritdoc}
   */
  public function getDefaultOption(): ?string {
    return 'migration';
  }

  /**
   * {@inheritdoc}
   */
  public function getRequiredOptions(): array {
    return ['migration'];
  }

}
